/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.serialize;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.api.serialize.FocessReader;
import top.focess.qq.api.serialize.SerializationParseException;
import top.focess.qq.core.plugin.PluginCoreClassLoader;

public class SimpleFocessReader
extends FocessReader {
    private static final PureJavaReflectionProvider PROVIDER = new PureJavaReflectionProvider();
    private static final Map<Class<?>, Reader<?>> CLASS_READER_MAP = Maps.newHashMap();
    private final byte[] bytes;
    private int pointer;

    public SimpleFocessReader(byte[] bytes) {
        this.bytes = bytes;
        this.pointer = 0;
    }

    private int readInt() {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r += Byte.toUnsignedInt(this.bytes[this.pointer++]) << i * 8;
        }
        return r;
    }

    private long readLong() {
        long r = 0L;
        for (int i = 0; i < 8; ++i) {
            r += Byte.toUnsignedLong(this.bytes[this.pointer++]) << (int)((long)i * 8L);
        }
        return r;
    }

    private String readString() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.bytes[this.pointer++];
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    private double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    private byte readByte() {
        return this.bytes[this.pointer++];
    }

    private short readShort() {
        short r = 0;
        for (int i = 0; i < 2; ++i) {
            r = (short)(r + ((short)Byte.toUnsignedInt(this.bytes[this.pointer++]) << i * 8));
        }
        return r;
    }

    private char readChar() {
        return (char)this.readShort();
    }

    private boolean readBoolean() {
        return this.readByte() == 1;
    }

    @Override
    public @Nullable Object read() {
        if (this.pointer >= this.bytes.length) {
            throw new SerializationParseException("Read over");
        }
        byte start = this.readByte();
        if (start != 20) {
            throw new SerializationParseException("Start code is not correct");
        }
        Object o = this.readObject();
        byte end = this.readByte();
        if (end != 21) {
            throw new SerializationParseException("End code is not correct");
        }
        return o;
    }

    private Class<?> readClass() {
        String cls;
        switch (cls = this.readString()) {
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        try {
            return PluginCoreClassLoader.forName(cls);
        }
        catch (ClassNotFoundException e) {
            throw new SerializationParseException(e);
        }
    }

    private <T> @Nullable Object readObject() {
        byte type = this.readByte();
        switch (type) {
            case 11: {
                return null;
            }
            case 0: {
                return this.readByte();
            }
            case 1: {
                return this.readShort();
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLong();
            }
            case 4: {
                return Float.valueOf(this.readFloat());
            }
            case 5: {
                return this.readDouble();
            }
            case 6: {
                return this.readBoolean();
            }
            case 7: {
                return Character.valueOf(this.readChar());
            }
            case 8: {
                return this.readString();
            }
            case 10: {
                Class<?> cls = this.readClass();
                int length = this.readInt();
                Object array = Array.newInstance(cls, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, this.readObject());
                }
                return array;
            }
            case 12: {
                String className = this.readString();
                Object o = this.readObject();
                try {
                    Class<?> cls = PluginCoreClassLoader.forName(className);
                    Method method = cls.getMethod("deserialize", Map.class);
                    return method.invoke(null, o);
                }
                catch (Exception e) {
                    throw new SerializationParseException(e);
                }
            }
            case 9: {
                String className = this.readString();
                int length = this.readInt();
                try {
                    Class<?> cls = PluginCoreClassLoader.forName(className);
                    Object o = PROVIDER.newInstance(cls);
                    for (int i = 0; i < length; ++i) {
                        byte field = this.readByte();
                        if (field != 13) {
                            throw new SerializationParseException("Field code is not correct");
                        }
                        String fieldName = this.readString();
                        Field f = cls.getDeclaredField(fieldName);
                        f.setAccessible(true);
                        f.set(o, this.readObject());
                    }
                    return o;
                }
                catch (Exception e) {
                    throw new SerializationParseException(e);
                }
            }
            case 14: {
                String className = this.readString();
                try {
                    Class<?> cls = PluginCoreClassLoader.forName(className);
                    Reader<?> reader = CLASS_READER_MAP.get(cls);
                    if (reader != null) {
                        return reader.read(cls, this);
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new SerializationParseException(e);
                }
            }
        }
        throw new SerializationParseException("Unknown type code");
    }

    static {
        CLASS_READER_MAP.put(ArrayList.class, (t, reader) -> {
            ArrayList<Object> list = new ArrayList<Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                list.add(reader.readObject());
            }
            return list;
        });
        CLASS_READER_MAP.put(LinkedList.class, (t, reader) -> {
            LinkedList<Object> list = new LinkedList<Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                list.offer(reader.readObject());
            }
            return list;
        });
        CLASS_READER_MAP.put(HashMap.class, (t, reader) -> {
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                hashMap.put(reader.readObject(), reader.readObject());
            }
            return hashMap;
        });
        CLASS_READER_MAP.put(TreeMap.class, (t, reader) -> {
            TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                treeMap.put(reader.readObject(), reader.readObject());
            }
            return treeMap;
        });
        CLASS_READER_MAP.put(HashSet.class, (t, reader) -> {
            HashSet<Object> hashSet = new HashSet<Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                hashSet.add(reader.readObject());
            }
            return hashSet;
        });
        CLASS_READER_MAP.put(TreeSet.class, (t, reader) -> {
            TreeSet<Object> treeSet = new TreeSet<Object>();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                treeSet.add(reader.readObject());
            }
            return treeSet;
        });
        CLASS_READER_MAP.put(Class.class, (t, reader) -> {
            try {
                String cls;
                switch (cls = reader.readString()) {
                    case "byte": {
                        return Byte.TYPE;
                    }
                    case "short": {
                        return Short.TYPE;
                    }
                    case "int": {
                        return Integer.TYPE;
                    }
                    case "long": {
                        return Long.TYPE;
                    }
                    case "float": {
                        return Float.TYPE;
                    }
                    case "double": {
                        return Double.TYPE;
                    }
                    case "boolean": {
                        return Boolean.TYPE;
                    }
                    case "char": {
                        return Character.TYPE;
                    }
                    case "void": {
                        return Void.TYPE;
                    }
                }
                return PluginCoreClassLoader.forName(cls);
            }
            catch (ClassNotFoundException e) {
                throw new SerializationParseException(e);
            }
        });
        CLASS_READER_MAP.put(ConcurrentHashMap.KeySetView.class, (t, reader) -> {
            ConcurrentHashMap.KeySetView<Object, Boolean> keySetView = ConcurrentHashMap.newKeySet();
            int length = reader.readInt();
            for (int i = 0; i < length; ++i) {
                keySetView.add(reader.readObject());
            }
            return keySetView;
        });
    }

    private static interface Reader<T> {
        public T read(Class<T> var1, SimpleFocessReader var2) throws SerializationParseException;
    }
}

