/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public class FocessLogger {
    private static final Logger LOG = LoggerFactory.getLogger(FocessLogger.class);

    public void info(String message) {
        LOG.info("[FocessQQ][Console] -> " + message);
    }

    public void infoLang(String key, Object ... objects) {
        this.info(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects));
    }

    public void consoleInput(String message) {
        LOG.debug("[FocessQQ][Console] <- " + message);
    }

    public void thr(String message, Throwable e) {
        LOG.error(message, e);
    }

    public void thrLang(String key, Throwable e, Object ... objects) {
        this.thr(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects), e);
    }

    public void fatal(String message) {
        LOG.error("[FocessQQ] + " + message);
    }

    public void fatalLang(String key, Object ... objects) {
        this.fatal(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects));
    }

    public void debug(String message) {
        LOG.debug("[FocessQQ] - " + message);
    }

    public void debugLang(String key, Object ... objects) {
        this.debug(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects));
    }

    public void trace(String message, Throwable e) {
        LOG.trace(message, e);
    }
}

