/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot.contact;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mamoe.mirai.contact.Contact;
import net.mamoe.mirai.contact.OtherClient;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.core.bot.contact.SimpleContact;

public class SimpleOtherClient
extends SimpleContact
implements top.focess.qq.api.bot.contact.OtherClient {
    private static final Map<Long, Map<Long, SimpleOtherClient>> OTHER_CLIENT_MAP = Maps.newConcurrentMap();
    private final OtherClient nativeOtherClient;

    public SimpleOtherClient(Bot bot, OtherClient contact) {
        super(bot, (Contact)contact);
        this.nativeOtherClient = contact;
    }

    @Override
    public String getName() {
        return this.nativeOtherClient.getInfo().getDeviceName();
    }

    @Nullable
    public static SimpleOtherClient get(Bot bot, @Nullable OtherClient otherClient) {
        if (otherClient == null) {
            return null;
        }
        if (otherClient.getBot().getId() != bot.getId()) {
            return null;
        }
        return OTHER_CLIENT_MAP.computeIfAbsent(bot.getId(), k -> Maps.newConcurrentMap()).computeIfAbsent(otherClient.getId(), k -> new SimpleOtherClient(bot, otherClient));
    }

    @Override
    public String getDeviceKind() {
        return this.nativeOtherClient.getInfo().getDeviceKind();
    }

    @Override
    public int getAppId() {
        return this.nativeOtherClient.getInfo().getAppId();
    }
}

