/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.PackHandler;
import top.focess.qq.api.net.packet.ClientPackPacket;
import top.focess.qq.api.net.packet.ConnectedPacket;
import top.focess.qq.api.net.packet.DisconnectPacket;
import top.focess.qq.api.net.packet.DisconnectedPacket;
import top.focess.qq.api.net.packet.HeartPacket;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.ServerPackPacket;
import top.focess.qq.api.net.packet.SidedConnectPacket;
import top.focess.qq.api.net.packet.WaitPacket;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.net.AServerReceiver;
import top.focess.qq.core.net.PacketHandler;
import top.focess.qq.core.net.SimpleClient;

public class FocessSidedReceiver
extends AServerReceiver {
    private final Map<String, Queue<Packet>> packets = Maps.newConcurrentMap();
    private final Scheduler scheduler = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin(), "FocessSidedReceiver");

    public FocessSidedReceiver() {
        this.scheduler.runTimer(() -> {
            for (SimpleClient simpleClient : this.clientInfos.values()) {
                long time = this.lastHeart.getOrDefault(simpleClient.getId(), 0L);
                if (System.currentTimeMillis() - time <= 10000L) continue;
                this.clientInfos.remove(simpleClient.getId());
            }
        }, Duration.ZERO, Duration.ofSeconds(1L));
    }

    @PacketHandler
    @Nullable
    public ConnectedPacket onConnect(SidedConnectPacket packet) {
        for (SimpleClient simpleClient : this.clientInfos.values()) {
            if (!simpleClient.getName().equals(packet.getName())) continue;
            return null;
        }
        SimpleClient simpleClient = new SimpleClient(this.defaultClientId++, packet.getName(), FocessSidedReceiver.generateToken());
        this.lastHeart.put(simpleClient.getId(), System.currentTimeMillis());
        this.clientInfos.put(simpleClient.getId(), simpleClient);
        return new ConnectedPacket(simpleClient.getId(), simpleClient.getToken());
    }

    @PacketHandler
    @Nullable
    public DisconnectedPacket onDisconnect(DisconnectPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            return this.disconnect(packet.getClientId());
        }
        return null;
    }

    @PacketHandler
    @Nullable
    public Packet onHeart(HeartPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken()) && System.currentTimeMillis() + 5000L > packet.getTime()) {
            this.lastHeart.put(simpleClient.getId(), packet.getTime());
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @PacketHandler
    @Nullable
    public Packet onClientPacket(ClientPackPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            for (Plugin plugin : this.packHandlers.keySet()) {
                for (PackHandler packHandler : (List)((Map)((Map)this.packHandlers.get(plugin)).getOrDefault(simpleClient.getName(), Maps.newHashMap())).getOrDefault(packet.getPacket().getClass(), Lists.newArrayList())) {
                    packHandler.handle(packet.getPacket());
                }
            }
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @PacketHandler
    @Nullable
    public Packet onWait(WaitPacket packet) {
        SimpleClient simpleClient;
        if (this.clientInfos.get(packet.getClientId()) != null && (simpleClient = (SimpleClient)this.clientInfos.get(packet.getClientId())).getToken().equals(packet.getToken())) {
            return this.packets.getOrDefault(simpleClient.getName(), Queues.newConcurrentLinkedQueue()).poll();
        }
        return null;
    }

    @Override
    public void sendPacket(String client, Packet packet) {
        this.packets.compute(client, (k, v) -> {
            if (v == null) {
                v = Queues.newConcurrentLinkedQueue();
            }
            v.offer(new ServerPackPacket(packet));
            return v;
        });
    }

    private DisconnectedPacket disconnect(int clientId) {
        this.clientInfos.remove(clientId);
        return new DisconnectedPacket();
    }

    @Override
    public boolean close() {
        this.scheduler.close();
        for (Integer id : this.clientInfos.keySet()) {
            this.disconnect(id);
        }
        return this.unregisterAll();
    }
}

