/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.net;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.ClientReceiver;
import top.focess.qq.api.net.IllegalPortException;
import top.focess.qq.api.net.PacketPreCodec;
import top.focess.qq.api.net.Receiver;
import top.focess.qq.api.net.ServerReceiver;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.net.ASocket;

public class FocessSocket
extends ASocket {
    private final ServerSocket server;
    private final int localPort;
    private boolean serverSide = false;
    private boolean clientSide = false;

    public FocessSocket(int localPort) throws IllegalPortException {
        this.localPort = localPort;
        try {
            this.server = new ServerSocket(localPort);
        }
        catch (IOException e) {
            throw new IllegalPortException(localPort);
        }
        Thread thread = new Thread(() -> {
            FocessQQ.getLogger().debugLang("start-focess-socket", localPort);
            while (!this.server.isClosed()) {
                try {
                    int length;
                    Socket socket = this.server.accept();
                    InputStream inputStream = socket.getInputStream();
                    byte[] buffer = new byte[1024];
                    PacketPreCodec packetPreCodec = new PacketPreCodec();
                    while ((length = inputStream.read(buffer)) != -1) {
                        packetPreCodec.push(buffer, length);
                    }
                    inputStream.close();
                    Packet packet = packetPreCodec.readPacket();
                    if (packet == null) continue;
                    for (Pair pair : (List)this.packetMethods.getOrDefault(packet.getClass(), Lists.newArrayList())) {
                        Method method = (Method)pair.getValue();
                        try {
                            method.setAccessible(true);
                            method.invoke(pair.getKey(), packet);
                        }
                        catch (Exception e) {
                            FocessQQ.getLogger().thrLang("exception-handle-packet", e, new Object[0]);
                        }
                    }
                }
                catch (IOException e) {
                    FocessQQ.getLogger().thrLang("exception-focess-socket", e, new Object[0]);
                    if (!this.server.isClosed()) continue;
                    return;
                }
            }
        });
        thread.start();
    }

    @Override
    public void registerReceiver(Receiver receiver) {
        if (receiver instanceof ServerReceiver) {
            this.serverSide = true;
        }
        if (receiver instanceof ClientReceiver) {
            this.clientSide = true;
        }
        super.registerReceiver(receiver);
    }

    @Override
    public boolean containsServerSide() {
        return this.serverSide;
    }

    @Override
    public boolean containsClientSide() {
        return this.clientSide;
    }

    public <T extends Packet> boolean sendPacket(String targetHost, int targetPort, T packet) {
        PacketPreCodec packetPreCodec = new PacketPreCodec();
        if (packetPreCodec.writePacket(packet)) {
            try {
                Socket socket = new Socket(targetHost, targetPort);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write(packetPreCodec.getBytes());
                outputStream.flush();
                outputStream.close();
                return true;
            }
            catch (IOException e) {
                FocessQQ.getLogger().thrLang("exception-send-packet", e, new Object[0]);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean close() {
        boolean ret = false;
        for (Receiver receiver : this.receivers) {
            ret = ret || receiver.close();
        }
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public int getLocalPort() {
        return this.localPort;
    }
}

