/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandArgument;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandResult;
import top.focess.qq.api.command.CommandSender;

public class ExecCommand
extends Command {
    public ExecCommand() {
        super("exec", new String[0]);
    }

    @Override
    public void init() {
        this.addExecutor((sender, dataCollection, ioHandler) -> {
            String command = dataCollection.get();
            List<String> args = CommandLine.splitCommand(command);
            if (args.size() == 0) {
                ioHandler.outputLang("exec-command-empty-command", new Object[0]);
                return CommandResult.REFUSE;
            }
            if (args.get(0).equalsIgnoreCase(this.getName()) || this.getAliases().stream().anyMatch(i -> i.equalsIgnoreCase((String)args.get(0)))) {
                ioHandler.outputLang("exec-command-error-command", new Object[0]);
                return CommandResult.REFUSE;
            }
            CommandLine.exec(sender, command, ioHandler);
            return CommandResult.ALLOW;
        }, CommandArgument.ofString());
    }

    @Override
    @NotNull
    public List<String> usage(CommandSender sender) {
        return Lists.newArrayList((Object[])new String[]{"Use: exec <command>"});
    }
}

