/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import java.util.function.Predicate;
import top.focess.qq.api.command.DataCollection;

public abstract class DataConverter<T> {
    public static final Predicate<String> INTEGER_PREDICATE = i -> {
        try {
            Integer.parseInt(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final Predicate<String> DOUBLE_PREDICATE = i -> {
        try {
            Double.parseDouble(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final Predicate<String> LONG_PREDICATE = i -> {
        try {
            Long.parseLong(i);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    };
    public static final DataConverter<String> DEFAULT_DATA_CONVERTER = new DataConverter<String>(){

        @Override
        protected boolean accept(String arg) {
            return true;
        }

        @Override
        public String convert(String arg) {
            return arg;
        }

        @Override
        protected Class<String> getTargetClass() {
            return String.class;
        }
    };
    public static final DataConverter<Integer> INTEGER_DATA_CONVERTER = new DataConverter<Integer>(){

        @Override
        protected boolean accept(String arg) {
            return INTEGER_PREDICATE.test(arg);
        }

        @Override
        public Integer convert(String arg) {
            return Integer.parseInt(arg);
        }

        @Override
        protected Class<Integer> getTargetClass() {
            return Integer.class;
        }
    };
    public static final DataConverter<Long> LONG_DATA_CONVERTER = new DataConverter<Long>(){

        @Override
        protected boolean accept(String arg) {
            return LONG_PREDICATE.test(arg);
        }

        @Override
        public Long convert(String arg) {
            return Long.parseLong(arg);
        }

        @Override
        protected Class<Long> getTargetClass() {
            return Long.class;
        }
    };
    public static final DataConverter<Double> DOUBLE_DATA_CONVERTER = new DataConverter<Double>(){

        @Override
        protected boolean accept(String s) {
            return DOUBLE_PREDICATE.test(s);
        }

        @Override
        public Double convert(String s) {
            return Double.parseDouble(s);
        }

        @Override
        protected Class<Double> getTargetClass() {
            return Double.class;
        }
    };
    public static final DataConverter<Boolean> BOOLEAN_DATA_CONVERTER = new DataConverter<Boolean>(){

        @Override
        protected boolean accept(String arg) {
            return arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false");
        }

        @Override
        public Boolean convert(String arg) {
            return Boolean.parseBoolean(arg);
        }

        @Override
        protected Class<Boolean> getTargetClass() {
            return Boolean.class;
        }
    };

    protected abstract boolean accept(String var1);

    public abstract T convert(String var1);

    boolean put(DataCollection dataCollection, String arg) {
        if (this.accept(arg)) {
            this.connect(dataCollection, this.convert(arg));
            return true;
        }
        return false;
    }

    void connect(DataCollection dataCollection, T arg) {
        dataCollection.write(this.getTargetClass(), arg);
    }

    protected abstract Class<T> getTargetClass();
}

