/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.version;

import top.focess.qq.api.util.version.VersionFormatException;

public class Version {
    public static final Version ALPHA_VERSION = new Version("alpha");
    public static final Version BETA_VERSION = new Version("beta");
    public static final Version BUILD_VERSION = new Version("build");
    public static final Version DEFAULT_VERSION = new Version("1.0.0");
    private final int length;
    private int major;
    private int minor;
    private int revision;
    private String build;

    public Version(int major, int minor, int revision, String build) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.build = build;
        this.length = 4;
    }

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.length = 3;
    }

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.length = 2;
    }

    public Version(String version) {
        String[] temp;
        block12: {
            temp = version.split("\\.");
            try {
                if (temp.length == 1) {
                    this.build = temp[0];
                    break block12;
                }
                if (temp.length == 2) {
                    this.major = Integer.parseInt(temp[0]);
                    String[] temp2 = temp[1].split("-");
                    this.minor = Integer.parseInt(temp2[0]);
                    if (temp2.length == 2) {
                        this.build = temp2[1];
                    } else if (temp2.length > 2) {
                        throw new VersionFormatException(version);
                    }
                    break block12;
                }
                if (temp.length == 3) {
                    this.major = Integer.parseInt(temp[0]);
                    this.minor = Integer.parseInt(temp[1]);
                    String[] temp2 = temp[2].split("-");
                    this.revision = Integer.parseInt(temp2[0]);
                    if (temp2.length == 2) {
                        this.build = temp2[1];
                    } else if (temp2.length > 2) {
                        throw new VersionFormatException(version);
                    }
                    break block12;
                }
                if (temp.length == 4) {
                    this.major = Integer.parseInt(temp[0]);
                    this.minor = Integer.parseInt(temp[1]);
                    this.revision = Integer.parseInt(temp[2]);
                    this.build = temp[3];
                    break block12;
                }
                throw new VersionFormatException(version);
            }
            catch (NumberFormatException e) {
                throw new VersionFormatException(version);
            }
        }
        this.length = temp.length;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getBuild() {
        return this.build;
    }

    public String toString() {
        if (this.length == 1) {
            return this.build;
        }
        if (this.length == 2) {
            return this.major + "." + this.minor + (this.build == null ? "" : "-" + this.build);
        }
        if (this.length == 3) {
            return this.major + "." + this.minor + "." + this.revision + (this.build == null ? "" : "-" + this.build);
        }
        if (this.length == 4) {
            return this.major + "." + this.minor + "." + this.revision + "." + this.build;
        }
        throw new VersionFormatException("");
    }
}

