/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.core.schedule.ITask;
import top.focess.qq.core.schedule.ThreadPoolScheduler;

public class ThreadPoolSchedulerThread
extends Thread {
    private final Object lock = new Object();
    private final ThreadPoolScheduler scheduler;
    private final String name;
    private boolean isAvailable = true;
    @Nullable
    private ITask task;
    private boolean shouldStop;

    public ThreadPoolSchedulerThread(ThreadPoolScheduler scheduler, String name) {
        super(name);
        this.scheduler = scheduler;
        this.name = name;
        this.setUncaughtExceptionHandler((t, e) -> {
            this.shouldStop = true;
            this.isAvailable = false;
            if (this.task != null) {
                this.task.setException(new ExecutionException(e));
                this.task.endRun();
                scheduler.taskThreadMap.remove(this.task);
            }
            FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread-uncaught", e, t.getName());
            scheduler.recreate(this.name);
        });
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    if (this.isAvailable) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    if (this.shouldStop) break block7;
                    if (this.task != null) {
                        this.task.startRun();
                        try {
                            this.task.run();
                        }
                        catch (Exception e) {
                            this.task.setException(new ExecutionException(e));
                        }
                        this.task.endRun();
                        this.scheduler.taskThreadMap.remove(this.task);
                        if (this.task.isPeriod()) {
                            this.scheduler.rerun(this.task);
                        }
                        this.task = null;
                    }
                    this.isAvailable = true;
                }
            }
            catch (Exception e) {
                FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread", e, new Object[0]);
                continue;
            }
            break;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTask(ITask task) {
        this.isAvailable = false;
        this.task = task;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.shouldStop = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void closeNow() {
        this.close();
        this.stop();
    }

    public void cancel() {
        this.stop();
        this.scheduler.recreate(this.name);
    }
}

