/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.CommandArgument;
import top.focess.qq.api.command.CommandDuplicateException;
import top.focess.qq.api.command.CommandExecutor;
import top.focess.qq.api.command.CommandLoadException;
import top.focess.qq.api.command.CommandPermission;
import top.focess.qq.api.command.CommandResult;
import top.focess.qq.api.command.CommandResultExecutor;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.DataConverter;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.command.CommandExecutedEvent;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.IOHandler;

public abstract class Command {
    private static final Map<String, Command> COMMANDS_MAP = Maps.newConcurrentMap();
    private final List<Executor> executors = Lists.newCopyOnWriteArrayList();
    private String name;
    private List<String> aliases;
    private Plugin plugin;
    private boolean registered;
    private CommandPermission permission;
    private Predicate<CommandSender> executorPermission;
    private boolean initialize;

    public Command(@NotNull String name, String ... aliases) {
        this.name = name;
        this.aliases = Lists.newArrayList((Object[])aliases);
        this.permission = CommandPermission.MEMBER;
        this.executorPermission = i -> true;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new CommandLoadException(this.getClass(), e);
        }
        this.initialize = true;
    }

    protected Command() {
        this.permission = CommandPermission.MEMBER;
        this.executorPermission = i -> true;
    }

    public static void unregister(Plugin plugin) {
        for (Command command : COMMANDS_MAP.values()) {
            if (!command.getPlugin().equals(plugin)) continue;
            command.unregister();
        }
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Command command : COMMANDS_MAP.values()) {
            if (command.getPlugin() != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            command.unregister();
        }
        return ret;
    }

    @NotNull
    public static List<Command> getCommands() {
        return Lists.newArrayList(COMMANDS_MAP.values());
    }

    public static void register(@NotNull Plugin plugin, @NotNull Command command) {
        if (command.name == null) {
            throw new IllegalStateException("CommandType does not contain name or the constructor does not super name");
        }
        ArrayList commandNames = Lists.newArrayList((Object[])new String[]{command.getName()});
        commandNames.addAll(command.getAliases());
        for (String commandName : commandNames) {
            for (Map.Entry<String, Command> entry : COMMANDS_MAP.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(commandName) && !entry.getValue().getAliases().stream().anyMatch(alias -> alias.equalsIgnoreCase(commandName))) continue;
                throw new CommandDuplicateException(commandName);
            }
        }
        command.registered = true;
        command.plugin = plugin;
        COMMANDS_MAP.put(command.getName(), command);
    }

    public boolean isRegistered() {
        return this.registered;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void unregister() {
        this.registered = false;
        this.executors.clear();
        COMMANDS_MAP.remove(this.getName());
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getAliases() {
        return this.aliases;
    }

    public Predicate<CommandSender> getExecutorPermission() {
        return this.executorPermission;
    }

    public void setExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
        this.executorPermission = executorPermission;
    }

    @NotNull
    public final Executor addExecutor(@NotNull CommandExecutor executor, CommandArgument<?> ... commandArguments) {
        Executor executor1 = new Executor(executor, this.executorPermission, this, commandArguments);
        this.executors.add(executor1);
        return executor1;
    }

    public final CommandResult execute(@NotNull CommandSender sender, @NotNull String[] args, @NotNull IOHandler ioHandler) {
        if (!this.isRegistered()) {
            return CommandResult.COMMAND_REFUSED;
        }
        if (!sender.hasPermission(this.getPermission())) {
            return CommandResult.COMMAND_REFUSED;
        }
        boolean flag = false;
        CommandResult result = CommandResult.NONE;
        for (Executor executor : this.executors) {
            DataCollection dataCollection;
            if (!sender.hasPermission(executor.permission) || (dataCollection = executor.check(args)) == null) continue;
            try {
                result = executor.execute(sender, dataCollection, ioHandler);
            }
            catch (Exception e) {
                result = CommandResult.REFUSE;
                FocessQQ.getLogger().thrLang("exception-command-execute", e, new Object[0]);
                ioHandler.outputLang("command-execute-exception", e.getMessage());
            }
            for (CommandResult r : executor.results.keySet()) {
                if ((r.getValue() & result.getValue()) == 0) continue;
                ((CommandResultExecutor)executor.results.get((Object)r)).execute(result);
            }
            CommandExecutedEvent event = new CommandExecutedEvent(executor, args, ioHandler, sender, result);
            try {
                EventManager.submit(event);
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-command-executed-event", e, new Object[0]);
            }
            flag = true;
            break;
        }
        if (this.executorPermission.test(sender) && (!flag || result == CommandResult.ARGS)) {
            this.infoUsage(sender, ioHandler);
            return CommandResult.ARGS;
        }
        return result;
    }

    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    public void setPermission(CommandPermission permission) {
        this.permission = permission;
    }

    public abstract void init();

    @NotNull
    public abstract List<String> usage(CommandSender var1);

    public final void infoUsage(CommandSender sender, IOHandler ioHandler) {
        List<String> usage = this.usage(sender);
        int targetPos = 7;
        StringBuilder stringBuilder = null;
        for (int pos = 0; pos != usage.size(); ++pos) {
            if (pos % 7 == 0) {
                if (stringBuilder != null) {
                    ioHandler.output(stringBuilder.toString());
                }
                stringBuilder = new StringBuilder(usage.get(pos));
                continue;
            }
            stringBuilder.append('\n').append(usage.get(pos));
        }
        if (stringBuilder != null) {
            ioHandler.output(stringBuilder.toString());
        }
    }

    public boolean isInitialize() {
        return this.initialize;
    }

    public static class Executor {
        private final Map<CommandResult, CommandResultExecutor> results = Maps.newHashMap();
        private final CommandExecutor executor;
        private final CommandArgument<?>[] commandArguments;
        private final Command command;
        private final int nullableCommandArguments;
        private CommandPermission permission = CommandPermission.MEMBER;
        private Predicate<CommandSender> executorPermission;

        private Executor(CommandExecutor executor, Predicate<CommandSender> executorPermission, Command command, CommandArgument<?>[] commandArguments) {
            this.executor = executor;
            this.executorPermission = executorPermission;
            this.command = command;
            this.commandArguments = commandArguments;
            this.nullableCommandArguments = (int)Arrays.stream(commandArguments).filter(CommandArgument::isNullable).count();
        }

        private CommandResult execute(CommandSender sender, DataCollection dataCollection, IOHandler ioHandler) {
            if (!this.executorPermission.test(sender)) {
                return CommandResult.REFUSE;
            }
            return this.executor.execute(sender, dataCollection, ioHandler);
        }

        @NotNull
        public Executor setPermission(@NotNull CommandPermission permission) {
            this.permission = permission;
            return this;
        }

        @NotNull
        public Executor addCommandResultExecutor(@NotNull CommandResult result, @NotNull CommandResultExecutor executor) {
            this.results.put(result, executor);
            return this;
        }

        @NotNull
        public Executor setExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
            this.executorPermission = this.executorPermission.and(executorPermission);
            return this;
        }

        @NotNull
        public Executor removeExecutorPermission() {
            this.executorPermission = i -> true;
            return this;
        }

        @NotNull
        public Executor overrideExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
            this.executorPermission = executorPermission;
            return this;
        }

        public Command getCommand() {
            return this.command;
        }

        @Nullable
        private DataCollection check(String[] args) {
            if (args.length > this.commandArguments.length) {
                return null;
            }
            if (args.length < this.commandArguments.length - this.nullableCommandArguments) {
                return null;
            }
            ArrayList commandArgumentList = Lists.newArrayList();
            boolean ret = this.dfsCheck(args, 0, 0, this.commandArguments.length - args.length, commandArgumentList);
            if (!ret) {
                return null;
            }
            DataCollection dataCollection = new DataCollection((DataConverter[])Arrays.stream(this.commandArguments).map(CommandArgument::getDataConverter).toArray(DataConverter[]::new));
            for (int i = 0; i < args.length; ++i) {
                ((CommandArgument)commandArgumentList.get(i)).put(dataCollection, args[i]);
            }
            dataCollection.flip();
            return dataCollection;
        }

        private boolean dfsCheck(@NotNull String[] args, int indexOfArgs, int index, int nullableCommandArguments, List<CommandArgument<?>> commandArgumentList) {
            boolean ret;
            if (indexOfArgs == args.length) {
                return true;
            }
            if (this.commandArguments[index].isNullable() && nullableCommandArguments > 0 && (ret = this.dfsCheck(args, indexOfArgs, index + 1, nullableCommandArguments - 1, commandArgumentList))) {
                return true;
            }
            if (this.commandArguments[index].accept(args[indexOfArgs])) {
                commandArgumentList.add(this.commandArguments[index]);
                ret = this.dfsCheck(args, indexOfArgs + 1, index + 1, nullableCommandArguments, commandArgumentList);
                if (ret) {
                    return true;
                }
                commandArgumentList.remove(commandArgumentList.size() - 1);
            }
            return false;
        }
    }
}

