/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.bot.contact.CommandExecutor;
import top.focess.qq.api.bot.contact.Friend;
import top.focess.qq.api.bot.contact.Member;
import top.focess.qq.api.bot.contact.Stranger;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandPermission;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.session.Session;
import top.focess.qq.core.listeners.ChatListener;

public class CommandSender {
    public static final CommandSender CONSOLE = new CommandSender();
    private static final Map<CommandSender, Session> SESSIONS = Maps.newHashMap();
    private final Member member;
    private final Friend friend;
    private final Stranger stranger;
    private final Bot bot;
    private final boolean isMember;
    private final boolean isFriend;
    private final CommandPermission permission;
    private final boolean isStranger;

    private CommandSender() {
        if (CONSOLE != null) {
            throw new IllegalStateException("CommandSender.CONSOLE is not null");
        }
        this.member = null;
        this.friend = null;
        this.stranger = null;
        this.bot = null;
        this.isFriend = false;
        this.isMember = false;
        this.isStranger = false;
        this.permission = CommandPermission.OWNER;
    }

    @Deprecated
    public CommandSender(@NonNull Friend friend) {
        this.member = null;
        this.stranger = null;
        this.friend = friend;
        this.bot = friend.getBot();
        this.isFriend = true;
        this.isMember = false;
        this.isStranger = false;
        this.permission = CommandPermission.OWNER;
    }

    @Deprecated
    public CommandSender(@NonNull Member member) {
        this.member = member;
        this.stranger = null;
        this.friend = null;
        this.bot = member.getBot();
        this.isMember = true;
        this.isFriend = false;
        this.isStranger = false;
        this.permission = member.getPermission();
    }

    @Deprecated
    public CommandSender(@NonNull Stranger stranger) {
        this.member = null;
        this.friend = null;
        this.stranger = stranger;
        this.bot = stranger.getBot();
        this.isMember = false;
        this.isFriend = false;
        this.isStranger = true;
        this.permission = CommandPermission.OWNER;
    }

    public static void clear(Plugin plugin) {
        SESSIONS.values().stream().map(Session::getValues).forEach(map -> {
            ArrayList keys = Lists.newArrayList();
            map.forEach((key, value) -> {
                if (key.startsWith(plugin.getName() + ":")) {
                    keys.add(key);
                }
            });
            keys.forEach(map::remove);
        });
    }

    public @Nullable Friend getFriend() {
        return this.friend;
    }

    @EnsuresNonNullIf(expression={"getFriend()"}, result=true)
    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean hasPermission(CommandPermission permission) {
        if (this.isAdministrator()) {
            return true;
        }
        return this.permission.hasPermission(permission);
    }

    public @Nullable Member getMember() {
        return this.member;
    }

    @EnsuresNonNullIf(expression={"getMember()"}, result=true)
    public boolean isMember() {
        return this.isMember;
    }

    public boolean isAdministrator() {
        if (FocessQQ.getAdministratorId() == null) {
            return false;
        }
        return this.isFriend ? this.friend.getId() == FocessQQ.getAdministratorId().longValue() : this.isMember && this.member.getId() == FocessQQ.getAdministratorId().longValue();
    }

    public @NonNull CommandPermission getPermission() {
        return this.permission;
    }

    public String toString() {
        if (this.isFriend()) {
            return this.friend.getRawName() + "(" + this.friend.getId() + ")";
        }
        if (this.isMember()) {
            return this.member.getCardName() + "(" + this.member.getId() + ")[" + this.member.getGroup().getId() + "]";
        }
        if (this.isStranger()) {
            return this.stranger.getRawName() + "(" + this.stranger.getId() + ")";
        }
        return "CONSOLE";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandSender sender = (CommandSender)o;
        if (this.isMember() && sender.isMember()) {
            return sender.getMember() == this.getMember();
        }
        if (this.isFriend() && sender.isFriend()) {
            return sender.getFriend() == this.getFriend();
        }
        if (this.isStranger() && sender.isStranger()) {
            return sender.getStranger() == this.getStranger();
        }
        return this.isConsole() && sender.isConsole();
    }

    public int hashCode() {
        int result = this.member != null ? this.member.hashCode() : 0;
        result = 31 * result + (this.friend != null ? this.friend.hashCode() : 0);
        result = 31 * result + (this.stranger != null ? this.stranger.hashCode() : 0);
        return result;
    }

    public boolean isConsole() {
        return this == CONSOLE;
    }

    public IOHandler getIOHandler() {
        if (this.isConsole()) {
            return IOHandler.getConsoleIoHandler();
        }
        return new IOHandler(){

            @Override
            public void output(String output) {
                if (CommandSender.this.isMember()) {
                    assert (CommandSender.this.getMember() != null);
                    CommandSender.this.getMember().getGroup().sendMessage(output);
                } else if (CommandSender.this.isFriend()) {
                    assert (CommandSender.this.getFriend() != null);
                    CommandSender.this.getFriend().sendMessage(output);
                } else if (CommandSender.this.isStranger()) {
                    assert (CommandSender.this.getStranger() != null);
                    CommandSender.this.getStranger().sendMessage(output);
                }
            }

            @Override
            public boolean hasInput(boolean flag) {
                ChatListener.registerInputListener(this, CommandSender.this, flag);
                while (!this.flag) {
                }
                return true;
            }
        };
    }

    public void exec(String command) {
        CommandLine.exec(this, command);
    }

    public Session getSession() {
        if (SESSIONS.containsKey(this)) {
            return SESSIONS.get(this);
        }
        Session session = new Session(null);
        SESSIONS.put(this, session);
        return session;
    }

    public @Nullable Bot getBot() {
        return this.bot;
    }

    @EnsuresNonNullIf(expression={"getStranger()"}, result=true)
    public boolean isStranger() {
        return this.isStranger;
    }

    public @Nullable Stranger getStranger() {
        return this.stranger;
    }

    public static CommandSender of(CommandExecutor executor) {
        if (executor instanceof Member) {
            return new CommandSender((Member)executor);
        }
        if (executor instanceof Friend) {
            return new CommandSender((Friend)executor);
        }
        if (executor instanceof Stranger) {
            return new CommandSender((Stranger)executor);
        }
        return CONSOLE;
    }
}

