/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util;

import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.util.InputTimeoutException;
import top.focess.qq.core.listeners.ConsoleListener;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public abstract class IOHandler {
    private static volatile IOHandler CONSOLE_IO_HANDLER = new IOHandler(){

        @Override
        public void output(@NotNull String output) {
            String[] messages = output.split("\n");
            Arrays.stream(messages).forEachOrdered(FocessQQ.getLogger()::info);
        }

        @Override
        public boolean hasInput(boolean flag) {
            ConsoleListener.registerInputListener(this);
            while (!this.flag) {
            }
            return true;
        }
    };
    private final Object LOCK = new Object();
    @Nullable
    protected volatile String value;
    protected volatile boolean flag;

    public static IOHandler getConsoleIoHandler() {
        return CONSOLE_IO_HANDLER;
    }

    public static void setConsoleIoHandler(IOHandler consoleIoHandler) {
        CONSOLE_IO_HANDLER = consoleIoHandler;
    }

    public abstract void output(String var1);

    public void outputLang(String key, Object ... objects) {
        this.output(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String input() throws InputTimeoutException {
        if (!this.flag) {
            this.hasInput();
        }
        this.flag = false;
        Object object = this.LOCK;
        synchronized (object) {
            if (this.value == null) {
                throw new InputTimeoutException();
            }
            return Objects.requireNonNull(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void input(@Nullable String input) {
        Object object = this.LOCK;
        synchronized (object) {
            this.value = input;
        }
        this.flag = true;
    }

    public boolean hasInput() {
        return this.hasInput(false);
    }

    public abstract boolean hasInput(boolean var1);
}

