/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.focess.qq.api.util.SectionMap;
import top.focess.qq.api.util.json.JSONList;
import top.focess.qq.api.util.json.JSONObject;
import top.focess.qq.api.util.json.JSONParseException;
import top.focess.qq.api.util.json.JSONSection;

public class JSON
extends JSONObject
implements SectionMap {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<String, Object>> TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private final Map<String, Object> values;

    public JSON(String json) {
        try {
            this.values = (Map)OBJECT_MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new JSONParseException(json);
        }
    }

    public JSON(Map<String, Object> values) {
        this.values = values;
    }

    @Override
    public JSONSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.set(key, values);
        return new JSONSection(this, values);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public JSONSection getSection(String key) {
        Object value = this.get(key);
        if (value == null) {
            this.createSection(key);
        }
        if (value instanceof Map) {
            return new JSONSection(this, (Map)value);
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    @Override
    public boolean containsSection(String key) {
        return this.get(key) instanceof Map;
    }

    @Override
    public JSONList getList(String key) {
        if (this.get(key) instanceof List) {
            return new JSONList((List)this.get(key));
        }
        throw new IllegalStateException("This " + key + " is not a valid list.");
    }

    @Override
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.values);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T get(String key) {
        return SectionMap.super.get(key);
    }

    public String toString() {
        return this.values.toString();
    }
}

