/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import top.focess.qq.api.util.json.JSON;
import top.focess.qq.api.util.json.JSONObject;
import top.focess.qq.api.util.json.JSONParseException;

public class JSONList
extends JSONObject {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<List<Object>> TYPE_REFERENCE = new TypeReference<List<Object>>(){};
    private final List<?> values;

    public JSONList(String json) {
        try {
            this.values = (List)OBJECT_MAPPER.readValue(json, TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new JSONParseException(json);
        }
    }

    public JSONList(List<?> values) {
        this.values = values;
    }

    @Override
    public <T> T get(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public JSON getJSON(int index) {
        if (this.values.get(index) instanceof Map) {
            return new JSON((Map)this.values.get(index));
        }
        throw new IllegalStateException("This element is not a valid map.");
    }

    @Override
    public JSONList getList(int index) {
        if (this.values.get(index) instanceof List) {
            return new JSONList((List)this.values.get(index));
        }
        throw new IllegalStateException("This element is not a valid list.");
    }

    public List<?> getValues() {
        return this.values;
    }

    @Override
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString(this.values);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.values.toString();
    }
}

