/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.session;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.SectionMap;
import top.focess.qq.api.util.session.SessionSection;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;

public class Session
implements SectionMap {
    private final Map<String, Object> values;

    public Session(@Nullable Map<String, Object> values) {
        this.values = values == null ? Maps.newHashMap() : values;
    }

    @Override
    public SessionSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.set(key, values);
        return new SessionSection(this, values);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    @Override
    public SectionMap getSection(String key) {
        Object value = this.get(key);
        if (value == null) {
            this.containsSection(key);
        }
        if (value instanceof Map) {
            return new SessionSection(this, (Map)value);
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    @Override
    public boolean containsSection(String key) {
        return this.get(key) instanceof Map;
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public void set(String key, Object value) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            SectionMap.super.set(plugin.getName() + ":" + key, value);
        } else {
            SectionMap.super.set(key, value);
        }
    }

    @Override
    public <T> T get(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return SectionMap.super.get(plugin.getName() + ":" + key);
        }
        return SectionMap.super.get(key);
    }

    @Override
    public <T> T getOrDefault(String key, T defaultValue) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return SectionMap.super.getOrDefault(plugin.getName() + ":" + key, defaultValue);
        }
        return SectionMap.super.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean contains(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return SectionMap.super.contains(plugin.getName() + ":" + key);
        }
        return SectionMap.super.contains(key);
    }

    @Override
    public void remove(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            SectionMap.super.remove(plugin.getName() + ":" + key);
        } else {
            SectionMap.super.remove(key);
        }
    }

    @Override
    public void compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            SectionMap.super.compute(plugin.getName() + ":" + key, remappingFunction);
        } else {
            SectionMap.super.compute(key, remappingFunction);
        }
    }
}

