/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.yaml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.Yaml;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.serialize.FocessSerializable;
import top.focess.qq.api.serialize.NotFocessSerializableException;
import top.focess.qq.api.serialize.SerializationParseException;
import top.focess.qq.api.util.SectionMap;
import top.focess.qq.api.util.yaml.YamlConfigurationSection;
import top.focess.qq.api.util.yaml.YamlLoadException;
import top.focess.qq.core.plugin.PluginCoreClassLoader;

public class YamlConfiguration
implements SectionMap {
    private static final Yaml YAML = new Yaml();
    private static final PureJavaReflectionProvider PROVIDER = new PureJavaReflectionProvider();
    private static final Map<Class<?>, ReservedHandler<?>> CLASS_RESERVED_HANDLER_MAP = Maps.newHashMap();
    private final Map<String, Object> values;

    public YamlConfiguration(@Nullable Map<String, Object> values) {
        this.values = values == null ? Maps.newHashMap() : values;
    }

    @NotNull
    public static YamlConfiguration loadFile(@NonNull File file) throws YamlLoadException {
        try {
            FileReader reader = new FileReader(file);
            YamlConfiguration yamlConfiguration = new YamlConfiguration((Map)YAML.load((Reader)reader));
            reader.close();
            return yamlConfiguration;
        }
        catch (IOException e) {
            throw new YamlLoadException(e);
        }
    }

    @NotNull
    @Contract(value="_ -> new")
    public static YamlConfiguration load(@Nullable InputStream inputStream) {
        if (inputStream == null) {
            return new YamlConfiguration(null);
        }
        return new YamlConfiguration((Map)YAML.load(inputStream));
    }

    private static <T> @Nullable Object write(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof Boolean || value instanceof String) {
            return value;
        }
        if (value.getClass().isEnum()) {
            HashMap ret = Maps.newHashMap();
            ret.put("class", "!!" + value.getClass().getName());
            ret.put("value", ((Enum)value).name());
            return ret;
        }
        if (value.getClass().isArray()) {
            HashMap ret = Maps.newHashMap();
            ret.put("class", "!!" + value.getClass().getComponentType().getName());
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < Array.getLength(value); ++i) {
                list.add(YamlConfiguration.write(Array.get(value, i)));
            }
            ret.put("value", list);
            ret.put("array", true);
            return ret;
        }
        if (value instanceof FocessSerializable) {
            HashMap ret = Maps.newHashMap();
            ret.put("class", "!!" + value.getClass().getName());
            HashMap data = ((FocessSerializable)value).serialize();
            if (data != null) {
                ret.put("value", data);
                ret.put("serialize", true);
                return ret;
            }
            data = Maps.newHashMap();
            for (Field field : value.getClass().getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0) continue;
                field.setAccessible(true);
                try {
                    data.put(field.getName(), YamlConfiguration.write(field.get(value)));
                }
                catch (IllegalAccessException e) {
                    throw new NotFocessSerializableException(value.getClass().getName());
                }
            }
            ret.put("value", data);
            return ret;
        }
        if (CLASS_RESERVED_HANDLER_MAP.containsKey(value.getClass())) {
            HashMap ret = Maps.newHashMap();
            Object t = value;
            ReservedHandler<?> handler = CLASS_RESERVED_HANDLER_MAP.get(value.getClass());
            ret.put("value", handler.write(t));
            ret.put("class", "!!" + value.getClass().getName());
            return ret;
        }
        throw new NotFocessSerializableException(value.getClass().getName());
    }

    private static <T, V extends Enum<V>> @Nullable Object read(Object value) {
        Map map;
        if (value == null) {
            return null;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof Boolean || value instanceof String) {
            return value;
        }
        if (value instanceof Map && (map = (Map)value).containsKey("class") && map.containsKey("value")) {
            String className = map.get("class").toString().substring(2);
            try {
                Class<?> cls = PluginCoreClassLoader.forName(className);
                Object v = map.get("value");
                if (cls.isEnum()) {
                    Class<?> enumClass = cls;
                    return Enum.valueOf(enumClass, ((Enum)v).name());
                }
                if (v instanceof List && Boolean.parseBoolean(String.valueOf(map.get("array")))) {
                    List list = (List)v;
                    Object array = Array.newInstance(cls, list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        Array.set(array, i, YamlConfiguration.read(list.get(i)));
                    }
                    return array;
                }
                if (v instanceof Map && FocessSerializable.class.isAssignableFrom(cls)) {
                    Map data = (Map)v;
                    if (Boolean.parseBoolean(String.valueOf(map.get("serialize")))) {
                        Method method = cls.getMethod("deserialize", Map.class);
                        return method.invoke(null, data);
                    }
                    Object o = PROVIDER.newInstance(cls);
                    for (String key : data.keySet()) {
                        Field f = cls.getDeclaredField(key);
                        f.setAccessible(true);
                        f.set(o, YamlConfiguration.read(data.get(key)));
                    }
                    return o;
                }
                if (CLASS_RESERVED_HANDLER_MAP.containsKey(cls)) {
                    ReservedHandler<?> handler = CLASS_RESERVED_HANDLER_MAP.get(cls);
                    return handler.read(v);
                }
            }
            catch (Exception e) {
                throw new SerializationParseException(e);
            }
        }
        throw new SerializationParseException("Unknown class: " + value.getClass().getName());
    }

    @Override
    public YamlConfigurationSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.set(key, values);
        return new YamlConfigurationSection(this, values);
    }

    @Override
    public void set(String key, @Nullable Object value) {
        this.values.put(key, YamlConfiguration.write(value));
    }

    @Override
    public <T> @Nullable T get(String key) {
        Object value = SectionMap.super.get(key);
        return (T)YamlConfiguration.read(value);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    public void save(File file) {
        try {
            YAML.dump(this.values, (Writer)new FileWriter(file));
        }
        catch (IOException e) {
            FocessQQ.getLogger().thrLang("exception-save-file", e, new Object[0]);
        }
    }

    @Override
    public YamlConfigurationSection getSection(String key) {
        Object value = this.get(key);
        if (value == null) {
            return this.createSection(key);
        }
        if (value instanceof Map) {
            return new YamlConfigurationSection(this, (Map)value);
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    @Override
    public boolean containsSection(String key) {
        return this.get(key) instanceof Map;
    }

    public String toString() {
        return this.values.toString();
    }

    static {
        CLASS_RESERVED_HANDLER_MAP.put(Class.class, new ReservedHandler<Class>(){

            @Override
            public Object write(Class value) {
                return value.getName();
            }

            @Override
            public Class read(Object value) {
                try {
                    String cls;
                    switch (cls = value.toString()) {
                        case "byte": {
                            return Byte.TYPE;
                        }
                        case "short": {
                            return Short.TYPE;
                        }
                        case "int": {
                            return Integer.TYPE;
                        }
                        case "long": {
                            return Long.TYPE;
                        }
                        case "float": {
                            return Float.TYPE;
                        }
                        case "double": {
                            return Double.TYPE;
                        }
                        case "boolean": {
                            return Boolean.TYPE;
                        }
                        case "char": {
                            return Character.TYPE;
                        }
                        case "void": {
                            return Void.TYPE;
                        }
                    }
                    return PluginCoreClassLoader.forName(cls);
                }
                catch (ClassNotFoundException e) {
                    throw new SerializationParseException(e);
                }
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(ArrayList.class, new ReservedHandler<ArrayList>(){

            @Override
            public Object write(ArrayList list) {
                return list.stream().map(x$0 -> YamlConfiguration.write(x$0)).collect(Collectors.toList());
            }

            @Override
            public ArrayList read(Object value) {
                List list = (List)value;
                ArrayList ret = Lists.newArrayList();
                for (Object o : list) {
                    ret.add(YamlConfiguration.read(o));
                }
                return ret;
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(HashSet.class, new ReservedHandler<HashSet>(){

            @Override
            public Object write(HashSet set) {
                return set.stream().map(x$0 -> YamlConfiguration.write(x$0)).collect(Collectors.toList());
            }

            @Override
            public HashSet read(Object value) {
                List list = (List)value;
                HashSet<Object> ret = new HashSet<Object>();
                for (Object o : list) {
                    ret.add(YamlConfiguration.read(o));
                }
                return ret;
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(ConcurrentHashMap.class, new ReservedHandler<ConcurrentHashMap>(){

            @Override
            public Object write(ConcurrentHashMap map) {
                return map;
            }

            @Override
            public ConcurrentHashMap read(Object value) {
                Map map = (Map)value;
                return new ConcurrentHashMap(map);
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(ConcurrentHashMap.KeySetView.class, new ReservedHandler<ConcurrentHashMap.KeySetView>(){

            @Override
            public Object write(ConcurrentHashMap.KeySetView set) {
                return set.stream().map(x$0 -> YamlConfiguration.write(x$0)).collect(Collectors.toList());
            }

            @Override
            public ConcurrentHashMap.KeySetView read(Object value) {
                List list = (List)value;
                ConcurrentHashMap.KeySetView<Object, Boolean> ret = ConcurrentHashMap.newKeySet();
                for (Object o : list) {
                    ret.add(YamlConfiguration.read(o));
                }
                return ret;
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(CopyOnWriteArrayList.class, new ReservedHandler<CopyOnWriteArrayList>(){

            @Override
            public Object write(CopyOnWriteArrayList value) {
                return value.stream().map(x$0 -> YamlConfiguration.write(x$0)).collect(Collectors.toList());
            }

            @Override
            public CopyOnWriteArrayList read(Object value) {
                List list = (List)value;
                CopyOnWriteArrayList<Object> ret = new CopyOnWriteArrayList<Object>();
                for (Object o : list) {
                    ret.add(YamlConfiguration.read(o));
                }
                return ret;
            }
        });
        CLASS_RESERVED_HANDLER_MAP.put(HashMap.class, new ReservedHandler<HashMap>(){

            @Override
            public Object write(HashMap map) {
                return map;
            }

            @Override
            public HashMap read(Object value) {
                return (HashMap)value;
            }
        });
    }

    private static interface ReservedHandler<T> {
        public Object write(T var1);

        public T read(Object var1);
    }
}

