/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.listeners;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.contact.CommandExecutor;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.CommandResult;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventPriority;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.bot.BotSendMessageEvent;
import top.focess.qq.api.event.chat.FriendChatEvent;
import top.focess.qq.api.event.chat.GroupChatEvent;
import top.focess.qq.api.event.chat.StrangerChatEvent;
import top.focess.qq.api.event.message.FriendMessageEvent;
import top.focess.qq.api.event.message.GroupMessageEvent;
import top.focess.qq.api.event.message.StrangerMessageEvent;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.api.util.InputTimeoutException;
import top.focess.qq.api.util.Pair;
import top.focess.qq.core.debug.Section;

public class ChatListener
implements Listener {
    public static final Map<CommandSender, Queue<Pair<IOHandler, Pair<Boolean, Long>>>> QUESTS = Maps.newConcurrentMap();
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 5, true, "ChatListener");

    public static void registerInputListener(IOHandler ioHandler, CommandSender commandSender, boolean flag) {
        QUESTS.compute(commandSender, (k, v) -> {
            if (v == null) {
                v = Queues.newLinkedBlockingDeque();
            }
            v.offer(Pair.of(ioHandler, Pair.of(flag, System.currentTimeMillis())));
            return v;
        });
    }

    private static void updateInput(CommandSender sender, String content, String miraiContent, AtomicBoolean flag) {
        QUESTS.compute(sender, (k, v) -> {
            if (v != null) {
                Pair element = (Pair)v.poll();
                while (element != null && System.currentTimeMillis() - (Long)((Pair)element.getValue()).getValue() > 300000L) {
                    ((IOHandler)element.getKey()).input(null);
                    element = (Pair)v.poll();
                }
                if (element == null) {
                    return v;
                }
                if (((Boolean)((Pair)element.getValue()).getKey()).booleanValue()) {
                    ((IOHandler)element.getKey()).input(miraiContent);
                } else {
                    ((IOHandler)element.getKey()).input(content);
                }
                flag.set(true);
            }
            return v;
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStrangerChat(@NotNull StrangerChatEvent event) {
        IOHandler.getConsoleIoHandler().output(String.format("%s(%d)", event.getStranger().getRawName(), event.getStranger().getId()));
        IOHandler.getConsoleIoHandler().outputLang("message-chain", new Object[0]);
        event.getMessage().stream().map(Object::toString).filter(i -> !i.isEmpty()).forEach(IOHandler.getConsoleIoHandler()::output);
        StrangerMessageEvent strangerMessageEvent = new StrangerMessageEvent(event.getBot(), event.getMessage(), event.getStranger(), event.getSource());
        try {
            EventManager.submit(strangerMessageEvent);
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-stranger-message-event", e, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onGroupChat(@NotNull GroupChatEvent event) {
        IOHandler.getConsoleIoHandler().output(String.format("%s(%d,%s) in %s(%d): %s", new Object[]{event.getMember().getCardName(), event.getMember().getId(), event.getMember().getPermission(), event.getGroup().getName(), event.getGroup().getId(), event.getMessage()}));
        IOHandler.getConsoleIoHandler().outputLang("message-chain", new Object[0]);
        event.getMessage().stream().map(Object::toString).filter(i -> !i.isEmpty()).forEach(IOHandler.getConsoleIoHandler()::output);
        CommandSender sender = event.getMember().getCommandSender();
        AtomicBoolean flag = new AtomicBoolean(false);
        ChatListener.updateInput(sender, event.getMessage().toString(), event.getMessage().toMiraiCode(), flag);
        if (!flag.get()) {
            try {
                Future<CommandResult> ret = CommandLine.exec(sender, event.getMessage().toString());
                EXECUTOR.run(() -> {
                    Section section;
                    block5: {
                        section = Section.startSection("command-group-exec", ret, Duration.ofMinutes(10L));
                        try {
                            if (ret.get() == CommandResult.NONE) {
                                GroupMessageEvent groupMessageEvent = new GroupMessageEvent(event.getBot(), event.getMember(), event.getMessage(), event.getSource());
                                try {
                                    EventManager.submit(groupMessageEvent);
                                }
                                catch (Exception e) {
                                    FocessQQ.getLogger().thrLang("exception-submit-group-message-event", e, new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof InputTimeoutException) break block5;
                            FocessQQ.getLogger().thrLang("exception-exec-group-command", e, new Object[0]);
                        }
                    }
                    section.stop();
                });
            }
            catch (Exception e) {
                FocessQQ.getLogger().thrLang("exception-exec-group-command", e, new Object[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFriendChat(@NotNull FriendChatEvent event) {
        IOHandler.getConsoleIoHandler().output(String.format("%s(%d)", event.getFriend().getRawName(), event.getFriend().getId()));
        IOHandler.getConsoleIoHandler().outputLang("message-chain", new Object[0]);
        event.getMessage().stream().map(Object::toString).filter(i -> !i.isEmpty()).forEach(IOHandler.getConsoleIoHandler()::output);
        CommandSender sender = event.getFriend().getCommandSender();
        AtomicBoolean flag = new AtomicBoolean(false);
        ChatListener.updateInput(sender, event.getMessage().toString(), event.getMessage().toMiraiCode(), flag);
        if (!flag.get()) {
            try {
                Future<CommandResult> ret = CommandLine.exec(sender, event.getMessage().toString());
                EXECUTOR.run(() -> {
                    Section section;
                    block5: {
                        section = Section.startSection("command-friend-exec", ret, Duration.ofMinutes(10L));
                        try {
                            if (ret.get() == CommandResult.NONE) {
                                FriendMessageEvent friendMessageEvent = new FriendMessageEvent(event.getBot(), event.getFriend(), event.getMessage(), event.getSource());
                                try {
                                    EventManager.submit(friendMessageEvent);
                                }
                                catch (Exception e) {
                                    FocessQQ.getLogger().thrLang("exception-submit-friend-message-event", e, new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (e.getCause() instanceof InputTimeoutException) break block5;
                            FocessQQ.getLogger().thrLang("exception-exec-friend-command", e, new Object[0]);
                        }
                    }
                    section.stop();
                });
            }
            catch (Exception e) {
                FocessQQ.getLogger().thrLang("exception-exec-friend-command", e, new Object[0]);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBotSendMessage(@NotNull BotSendMessageEvent event) {
        List<String> args = CommandLine.splitCommand(event.getMessage().toString());
        if (args.size() != 0 && args.get(0).equalsIgnoreCase("exec") && event.getContact() instanceof CommandExecutor) {
            CommandLine.exec(((CommandExecutor)((Object)event.getContact())).getCommandSender(), event.getMessage().toString());
        }
    }
}

