/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.util.option;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.core.util.option.Option;
import top.focess.qq.core.util.option.OptionParserClassifier;

public class Options {
    private final Map<String, Option> options = Maps.newHashMap();

    @NotNull
    public static Options parse(@NotNull String[] args, OptionParserClassifier ... classifiers) {
        ArrayList temp = Lists.newArrayList();
        ArrayList defaultClassifier = Lists.newArrayList();
        Options options = new Options();
        for (String arg : args) {
            if (arg.startsWith("--")) {
                for (OptionParserClassifier classifier : defaultClassifier) {
                    options.add(classifier.createOption(temp.toArray(new String[0])));
                }
                defaultClassifier.clear();
                temp.clear();
                for (OptionParserClassifier classifier : classifiers) {
                    if (!arg.equals("--" + classifier.getName())) continue;
                    defaultClassifier.add(classifier);
                }
                continue;
            }
            temp.add(arg);
        }
        for (OptionParserClassifier classifier : defaultClassifier) {
            options.add(classifier.createOption(temp.toArray(new String[0])));
        }
        return options;
    }

    private void add(@Nullable Option option) {
        if (option == null) {
            return;
        }
        this.options.put(option.getName(), option);
    }

    @Nullable
    public Option get(String name) {
        return this.options.get(name);
    }

    public String toString() {
        return "Options{options=" + this.options + '}';
    }
}

