/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import top.focess.command.Command;
import top.focess.command.CommandArgument;
import top.focess.command.CommandPermission;
import top.focess.command.CommandResult;
import top.focess.command.IOHandler;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.CommandExecutor;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.command.CommandExecutedEvent;
import top.focess.qq.api.plugin.Plugin;

public abstract class Command {
    private static final Map<String, Command> COMMANDS_MAP = Maps.newConcurrentMap();
    private top.focess.command.Command command;
    private Plugin plugin;

    public Command(@NotNull String name, String ... aliases) {
        this.command = new top.focess.command.Command(name, aliases){

            public void init() {
                Command.this.init();
            }

            @NotNull
            public List<String> usage(top.focess.command.CommandSender commandSender) {
                return Command.this.usage((CommandSender)commandSender);
            }
        };
    }

    protected Command() {
    }

    public static void unregister(Plugin plugin) {
        for (Command command : COMMANDS_MAP.values()) {
            if (!command.getPlugin().equals(plugin)) continue;
            command.unregister();
        }
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Command command : COMMANDS_MAP.values()) {
            if (command.getPlugin() != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            command.unregister();
        }
        return ret;
    }

    @NotNull
    public static List<Command> getCommands() {
        return Lists.newArrayList(COMMANDS_MAP.values());
    }

    public static void register(@NotNull Plugin plugin, @NotNull Command command) {
        top.focess.command.Command.register((top.focess.command.Command)command.command);
        command.plugin = plugin;
        COMMANDS_MAP.put(command.getName(), command);
    }

    public boolean isRegistered() {
        return this.command.isRegistered();
    }

    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    public void unregister() {
        this.command.unregister();
        COMMANDS_MAP.remove(this.getName());
    }

    @NotNull
    public String getName() {
        return this.command.getName();
    }

    @NotNull
    public List<String> getAliases() {
        return this.command.getAliases();
    }

    public Predicate<CommandSender> getExecutorPermission() {
        return i -> this.command.getExecutorPermission().test(i);
    }

    public void setExecutorPermission(@NotNull Predicate<CommandSender> executorPermission) {
        this.command.setExecutorPermission(i -> executorPermission.test((CommandSender)((Object)i)));
    }

    @NotNull
    public final Command.Executor addExecutor(@NotNull CommandExecutor executor, CommandArgument<?> ... commandArguments) {
        return this.command.addExecutor((top.focess.command.CommandExecutor)executor, commandArguments);
    }

    public final CommandResult execute(@NotNull CommandSender sender, @NotNull String[] args, @NotNull top.focess.qq.api.util.IOHandler ioHandler) {
        CommandResult result = this.command.execute((top.focess.command.CommandSender)sender, args, (IOHandler)ioHandler);
        if (result.isExecuted()) {
            CommandExecutedEvent event = new CommandExecutedEvent(args, ioHandler, sender, result);
            try {
                EventManager.submit(event);
            }
            catch (EventSubmitException e) {
                FocessQQ.getLogger().thrLang("exception-submit-command-executed-event", e, new Object[0]);
            }
        }
        return result;
    }

    @NotNull
    public CommandPermission getPermission() {
        return this.command.getPermission();
    }

    public void setPermission(CommandPermission permission) {
        this.command.setPermission(permission);
    }

    public abstract void init();

    @NotNull
    public abstract List<String> usage(CommandSender var1);

    public final void infoUsage(CommandSender sender, top.focess.qq.api.util.IOHandler ioHandler) {
        this.command.infoUsage((top.focess.command.CommandSender)sender, (IOHandler)ioHandler);
    }
}

