/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command.data;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.Command;
import top.focess.command.data.DataBuffer;
import top.focess.command.data.StringBuffer;

public class CommandBuffer
extends DataBuffer<Command> {
    private final StringBuffer stringBuffer;

    public CommandBuffer(int size) {
        this.stringBuffer = StringBuffer.allocate((int)size);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static CommandBuffer allocate(int size) {
        return new CommandBuffer(size);
    }

    public void flip() {
        this.stringBuffer.flip();
    }

    public void put(@NotNull Command command) {
        this.stringBuffer.put(command.getName());
    }

    @NotNull
    public Command get() {
        String name = this.stringBuffer.get();
        for (Command command : Command.getCommands()) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        throw new IllegalArgumentException("Command: " + name + " is not found");
    }

    @NotNull
    public Command get(int index) {
        String name = this.stringBuffer.get(index);
        for (Command command : Command.getCommands()) {
            if (!command.getName().equals(name)) continue;
            return command;
        }
        throw new IllegalArgumentException("Command: " + name + " is not found");
    }
}

