/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.schedule;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.schedule.Callback;
import top.focess.qq.api.schedule.Scheduler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.schedule.Task;
import top.focess.qq.api.schedule.TaskNotFinishedException;
import top.focess.qq.core.schedule.FocessTask;

public class FocessCallback<V>
extends FocessTask
implements Callback<V> {
    private static final Scheduler DEFAULT_SCHEDULER = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 7, false, "FocessCallback");
    private final Callable<V> callback;
    private V value;

    FocessCallback(Callable<V> callback, Scheduler scheduler) {
        super(null, scheduler);
        this.callback = callback;
    }

    @Override
    public V call() throws TaskNotFinishedException, CancellationException, ExecutionException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        if (!this.isFinished) {
            throw new TaskNotFinishedException(this);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    @Override
    public V waitCall() throws InterruptedException, ExecutionException {
        this.join();
        return this.call();
    }

    @Override
    public synchronized V get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        Task task;
        block3: {
            if (this.isFinished()) {
                return this.value;
            }
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            AtomicBoolean out = new AtomicBoolean(false);
            task = DEFAULT_SCHEDULER.run(() -> {
                out.set(true);
                FocessCallback focessCallback = this;
                synchronized (focessCallback) {
                    this.notifyAll();
                }
            }, Duration.ofMillis(unit.toMillis(timeout)));
            do {
                this.wait();
                if (this.isCancelled() || this.isFinished()) break block3;
            } while (!out.get());
            throw new TimeoutException();
        }
        task.cancel();
        return this.call();
    }

    @Override
    public void run() throws ExecutionException {
        try {
            this.value = this.callback.call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }
}

