/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.serialize;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.serialize.FocessSerializable;
import top.focess.qq.api.serialize.FocessWriter;
import top.focess.qq.api.serialize.NotFocessSerializableException;

public class SimpleFocessWriter
extends FocessWriter {
    private static final Map<Class<?>, Writer<?>> CLASS_WRITER_MAP = Maps.newHashMap();
    private final List<Byte> data = Lists.newArrayList();

    private void writeInt(int v) {
        for (int i = 0; i < 4; ++i) {
            this.data.add((byte)(v & 0xFF));
            v >>>= 8;
        }
    }

    private void writeLong(long v) {
        for (int i = 0; i < 8; ++i) {
            this.data.add((byte)(v & 0xFFL));
            v >>>= 8;
        }
    }

    private void writeString(String v) {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.data.addAll(Bytes.asList((byte[])bytes));
    }

    private void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    private void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    private void writeShort(short v) {
        for (int i = 0; i < 2; ++i) {
            this.data.add((byte)(v & 0xFF));
            v = (short)(v >>> 8);
        }
    }

    private void writeBoolean(boolean v) {
        this.data.add((byte)(v ? 1 : 0));
    }

    private void writeChar(char v) {
        this.writeShort((short)v);
    }

    private void writeClass(Class<?> cls, boolean isSerializable) {
        if (cls.equals(Byte.class)) {
            this.writeByte((byte)0);
        } else if (cls.equals(Short.class)) {
            this.writeByte((byte)1);
        } else if (cls.equals(Integer.class)) {
            this.writeByte((byte)2);
        } else if (cls.equals(Long.class)) {
            this.writeByte((byte)3);
        } else if (cls.equals(Float.class)) {
            this.writeByte((byte)4);
        } else if (cls.equals(Double.class)) {
            this.writeByte((byte)5);
        } else if (cls.equals(Boolean.class)) {
            this.writeByte((byte)6);
        } else if (cls.equals(Character.class)) {
            this.writeByte((byte)7);
        } else if (cls.equals(String.class)) {
            this.writeByte((byte)8);
        } else if (cls.isArray()) {
            this.writeByte((byte)10);
        } else if (cls.isEnum()) {
            this.writeByte((byte)15);
            this.writeString(cls.getName());
        } else if (FocessSerializable.class.isAssignableFrom(cls)) {
            if (isSerializable) {
                this.writeByte((byte)12);
            } else {
                this.writeByte((byte)9);
            }
            this.writeString(cls.getName());
        } else if (CLASS_WRITER_MAP.containsKey(cls)) {
            this.writeByte((byte)14);
            this.writeString(cls.getName());
        } else {
            throw new NotFocessSerializableException(cls.getName());
        }
    }

    private <T> void writeObject(Object o) {
        if (o == null) {
            this.writeByte((byte)11);
            return;
        }
        boolean isSerializable = o instanceof FocessSerializable;
        Map<String, Object> data = isSerializable ? ((FocessSerializable)o).serialize() : null;
        this.writeClass(o.getClass(), data != null);
        if (o instanceof Byte) {
            this.writeByte((Byte)o);
        } else if (o instanceof Short) {
            this.writeShort((Short)o);
        } else if (o instanceof Integer) {
            this.writeInt((Integer)o);
        } else if (o instanceof Long) {
            this.writeLong((Long)o);
        } else if (o instanceof Float) {
            this.writeFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            this.writeDouble((Double)o);
        } else if (o instanceof Boolean) {
            this.writeBoolean((Boolean)o);
        } else if (o instanceof String) {
            this.writeString((String)o);
        } else if (o instanceof Character) {
            this.writeChar(((Character)o).charValue());
        } else if (o.getClass().isEnum()) {
            this.writeString(((Enum)o).name());
        } else if (o instanceof FocessSerializable) {
            if (data != null) {
                this.writeObject(data);
            } else {
                List<Field> fields = Stream.of(o.getClass().getDeclaredFields()).filter(f -> (f.getModifiers() & 0x88) == 0).collect(Collectors.toList());
                this.writeInt(fields.size());
                fields.forEach(f -> {
                    f.setAccessible(true);
                    try {
                        this.writeField(f.getName(), f.get(o));
                    }
                    catch (IllegalAccessException e) {
                        FocessQQ.getLogger().thrLang("exception-serialize-field", e, f.getName(), o.getClass().getName());
                    }
                });
            }
        } else if (o.getClass().isArray()) {
            this.writeString(o.getClass().getComponentType().getName());
            int length = Array.getLength(o);
            this.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeObject(Array.get(o, i));
            }
        } else if (CLASS_WRITER_MAP.containsKey(o.getClass())) {
            Object t = o;
            Writer<?> writer = CLASS_WRITER_MAP.get(o.getClass());
            writer.write(t, this);
        } else {
            throw new NotFocessSerializableException(o.getClass().getName());
        }
    }

    private void writeField(String name, Object o) {
        this.writeByte((byte)13);
        this.writeString(name);
        this.writeObject(o);
    }

    @Override
    public void write(Object o) {
        this.writeByte((byte)20);
        this.writeObject(o);
        this.writeByte((byte)21);
    }

    private void writeByte(Byte o) {
        this.data.add(o);
    }

    public byte[] toByteArray() {
        return Bytes.toArray(this.data);
    }

    static {
        CLASS_WRITER_MAP.put(ArrayList.class, (list, writer) -> {
            writer.writeInt(list.size());
            for (Object o : list) {
                writer.writeObject(o);
            }
        });
        CLASS_WRITER_MAP.put(LinkedList.class, (linkedList, writer) -> {
            writer.writeInt(linkedList.size());
            for (Object o : linkedList) {
                writer.writeObject(o);
            }
        });
        CLASS_WRITER_MAP.put(HashMap.class, (hashMap, writer) -> {
            writer.writeInt(hashMap.size());
            for (Object o : hashMap.keySet()) {
                writer.writeObject(o);
                writer.writeObject(hashMap.get(o));
            }
        });
        CLASS_WRITER_MAP.put(TreeSet.class, (set, writer) -> {
            writer.writeInt(set.size());
            for (Object o : set) {
                writer.writeObject(o);
            }
        });
        CLASS_WRITER_MAP.put(HashSet.class, (set, writer) -> {
            writer.writeInt(set.size());
            for (Object o : set) {
                writer.writeObject(o);
            }
        });
        CLASS_WRITER_MAP.put(TreeMap.class, (map, writer) -> {
            writer.writeInt(map.size());
            for (Object o : map.keySet()) {
                writer.writeObject(o);
                writer.writeObject(map.get(o));
            }
        });
        CLASS_WRITER_MAP.put(Class.class, (clazz, writer) -> writer.writeString(clazz.getName()));
        CLASS_WRITER_MAP.put(ConcurrentHashMap.KeySetView.class, (set, writer) -> {
            writer.writeInt(set.size());
            for (Object o : set) {
                writer.writeObject(o);
            }
        });
    }

    private static interface Writer<T> {
        public void write(T var1, SimpleFocessWriter var2) throws NotFocessSerializableException;
    }
}

