/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Bytes;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.net.packet.ClientPackPacketCodec;
import top.focess.qq.api.net.packet.ConnectPacketCodec;
import top.focess.qq.api.net.packet.ConnectedPacketCodec;
import top.focess.qq.api.net.packet.DisconnectPacketCodec;
import top.focess.qq.api.net.packet.DisconnectedPacketCodec;
import top.focess.qq.api.net.packet.HeartPacketCodec;
import top.focess.qq.api.net.packet.MessagePacketCodec;
import top.focess.qq.api.net.packet.Packet;
import top.focess.qq.api.net.packet.PacketCodec;
import top.focess.qq.api.net.packet.ServerPackPacketCodec;
import top.focess.qq.api.net.packet.SidedConnectPacketCodec;
import top.focess.qq.api.net.packet.WaitPacketCodec;

public class PacketPreCodec {
    private static final Map<Integer, PacketCodec<? extends Packet>> PACKET_CODECS = Maps.newHashMap();
    private final List<Byte> data = Lists.newArrayList();
    private int pointer;

    public static <T extends Packet> void registerPacketCodec(int packetId, PacketCodec<T> packetCodec) {
        PACKET_CODECS.put(packetId, packetCodec);
    }

    public int readInt() {
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r += Byte.toUnsignedInt(this.data.get(this.pointer++)) << i * 8;
        }
        return r;
    }

    public long readLong() {
        long r = 0L;
        for (int i = 0; i < 8; ++i) {
            r += Byte.toUnsignedLong(this.data.get(this.pointer++)) << (int)((long)i * 8L);
        }
        return r;
    }

    public void writeInt(int v) {
        for (int i = 0; i < 4; ++i) {
            this.data.add((byte)(v & 0xFF));
            v >>>= 8;
        }
    }

    public void writeLong(long v) {
        for (int i = 0; i < 8; ++i) {
            this.data.add((byte)(v & 0xFFL));
            v >>>= 8;
        }
    }

    public void writeString(@NotNull String v) {
        byte[] bytes = v.getBytes(StandardCharsets.UTF_8);
        this.writeInt(bytes.length);
        this.data.addAll(Bytes.asList((byte[])bytes));
    }

    public String readString() {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.data.get(this.pointer++);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public byte readByte() {
        return this.data.get(this.pointer++);
    }

    public void writeByte(byte b) {
        this.data.add(b);
    }

    public short readShort() {
        short r = 0;
        for (int i = 0; i < 2; ++i) {
            r = (short)(r + (short)((short)Byte.toUnsignedInt(this.data.get(this.pointer++)) << i * 8));
        }
        return r;
    }

    public void writeShort(short v) {
        for (int i = 0; i < 2; ++i) {
            this.data.add((byte)(v & 0xFF));
            v = (short)(v >>> 8);
        }
    }

    public byte[] getBytes() {
        return Bytes.toArray(this.data);
    }

    @Nullable
    public Packet readPacket() {
        int packetId;
        try {
            packetId = this.readInt();
        }
        catch (Exception e) {
            return null;
        }
        PacketCodec<? extends Packet> packetCodec = PACKET_CODECS.get(packetId);
        if (packetCodec != null) {
            return packetCodec.readPacket(this);
        }
        FocessQQ.getLogger().debugLang("unknown-packet", packetId);
        return null;
    }

    public <T extends Packet> boolean writePacket(@NotNull T packet) {
        int packetId = packet.getId();
        PacketCodec<? extends Packet> packetCodec = PACKET_CODECS.get(packetId);
        if (packetCodec != null) {
            this.writeInt(packetId);
            packetCodec.writePacket(packet, this);
            return true;
        }
        FocessQQ.getLogger().debugLang("unknown-packet", packetId);
        return false;
    }

    public void push(byte[] buffer, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            this.data.add(buffer[i]);
        }
    }

    public void push(byte[] buffer, int length) {
        this.push(buffer, 0, length);
    }

    static {
        PacketPreCodec.registerPacketCodec(1, new MessagePacketCodec());
        PacketPreCodec.registerPacketCodec(2, new HeartPacketCodec());
        PacketPreCodec.registerPacketCodec(3, new ConnectPacketCodec());
        PacketPreCodec.registerPacketCodec(4, new ConnectedPacketCodec());
        PacketPreCodec.registerPacketCodec(5, new DisconnectPacketCodec());
        PacketPreCodec.registerPacketCodec(6, new DisconnectedPacketCodec());
        PacketPreCodec.registerPacketCodec(7, new ClientPackPacketCodec());
        PacketPreCodec.registerPacketCodec(8, new ServerPackPacketCodec());
        PacketPreCodec.registerPacketCodec(9, new SidedConnectPacketCodec());
        PacketPreCodec.registerPacketCodec(10, new WaitPacketCodec());
    }
}

