/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.plugin;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.util.version.Version;
import top.focess.util.yaml.YamlConfiguration;

public class PluginDescription {
    private final String main;
    private final List<String> dependencies;
    private final List<String> softDependencies;
    private final String author;
    private final Version version;
    private final String name;

    public PluginDescription(@NotNull YamlConfiguration pluginConfig) {
        this.main = (String)pluginConfig.get("main");
        this.author = (String)pluginConfig.getOrDefault("author", (Object)"");
        this.dependencies = pluginConfig.getListOrEmpty("depend");
        this.softDependencies = pluginConfig.getListOrEmpty("softdepend");
        this.version = new Version((String)pluginConfig.getOrDefault("version", (Object)"1.0.0"));
        this.name = (String)pluginConfig.getOrDefault("name", (Object)"");
    }

    PluginDescription() {
        this.main = FocessQQ.MainPlugin.class.getName();
        this.author = "MidCoard";
        this.dependencies = Lists.newArrayList();
        this.softDependencies = Lists.newArrayList();
        this.version = FocessQQ.getVersion();
        this.name = "MainPlugin";
    }

    public String getMain() {
        return this.main;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getSoftDependencies() {
        return this.softDependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public Version getVersion() {
        return this.version;
    }
}

