/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.event.Cancellable;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.plugin.Plugin;
import top.focess.util.Pair;

public class ListenerHandler {
    static final Map<Listener, Plugin> LISTENER_PLUGIN_MAP = Maps.newConcurrentMap();
    private static final List<ListenerHandler> LISTENER_HANDLER_LIST = Lists.newArrayList();
    private static final Map<Plugin, List<Listener>> PLUGIN_LISTENER_MAP = Maps.newConcurrentMap();
    private final Map<Listener, List<Pair<Method, EventHandler>>> listeners = Maps.newHashMap();

    public ListenerHandler() {
        LISTENER_HANDLER_LIST.add(this);
    }

    public static void unregister(Plugin plugin) {
        List<Listener> listeners = PLUGIN_LISTENER_MAP.getOrDefault(plugin, Lists.newArrayList());
        for (ListenerHandler handler : LISTENER_HANDLER_LIST) {
            for (Listener listener : listeners) {
                LISTENER_PLUGIN_MAP.remove(listener);
                handler.unregister(listener);
            }
        }
        PLUGIN_LISTENER_MAP.remove(plugin);
    }

    public static void unregister(Plugin plugin, Listener listener) {
        PLUGIN_LISTENER_MAP.computeIfPresent(plugin, (k, v) -> {
            v.remove(listener);
            return v;
        });
        for (ListenerHandler handler : LISTENER_HANDLER_LIST) {
            handler.unregister(listener);
        }
        LISTENER_PLUGIN_MAP.remove(listener);
    }

    public static void register(Plugin plugin, Listener listener) {
        PLUGIN_LISTENER_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(listener);
            return v;
        });
        LISTENER_PLUGIN_MAP.put(listener, plugin);
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Plugin plugin : PLUGIN_LISTENER_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            ListenerHandler.unregister(plugin);
        }
        PLUGIN_LISTENER_MAP.clear();
        return ret;
    }

    public void unregister(Listener listener) {
        this.listeners.remove(listener);
    }

    public <T extends Event> void register(Listener listener, Method method, EventHandler handler) {
        this.listeners.compute(listener, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(Pair.of((Object)method, (Object)handler));
            return v;
        });
    }

    public <T extends Event> void submit(T event) {
        for (Listener listener : this.listeners.keySet()) {
            this.listeners.get(listener).stream().sorted(Comparator.comparing(pair -> ((EventHandler)pair.getValue()).priority().getPriority())).forEachOrdered(i -> {
                if (event.isPrevent() && ((EventHandler)i.getValue()).notCallIfPrevented()) {
                    return;
                }
                if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled() && ((EventHandler)i.getValue()).notCallIfCancelled()) {
                    return;
                }
                Method method = (Method)i.getKey();
                try {
                    method.setAccessible(true);
                    method.invoke((Object)listener, event);
                }
                catch (Exception e) {
                    FocessQQ.getLogger().thrLang("exception-handle-event", e, event.getClass().getName());
                }
            });
        }
    }
}

