/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util.session;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.util.session.SessionSection;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;
import top.focess.util.SectionMap;

public class Session
implements SectionMap {
    private final Map<String, Object> values;

    public Session(@Nullable Map<String, Object> values) {
        this.values = values == null ? Maps.newHashMap() : values;
    }

    public SessionSection createSection(String key) {
        HashMap values = Maps.newHashMap();
        this.set(key, values);
        return new SessionSection(this, values);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public SectionMap getSection(String key) {
        Object value = this.get(key);
        if (value == null) {
            this.containsSection(key);
        }
        if (value instanceof Map) {
            return new SessionSection(this, (Map)value);
        }
        throw new IllegalStateException("This " + key + " is not a valid section.");
    }

    public boolean containsSection(String key) {
        return this.get(key) instanceof Map;
    }

    public String toString() {
        return this.values.toString();
    }

    public void set(String key, Object value) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            super.set(plugin.getName() + ":" + key, value);
        } else {
            super.set(key, value);
        }
    }

    public <T> T get(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return (T)super.get(plugin.getName() + ":" + key);
        }
        return (T)super.get(key);
    }

    public <T> T getOrDefault(String key, T defaultValue) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return (T)super.getOrDefault(plugin.getName() + ":" + key, defaultValue);
        }
        return (T)super.getOrDefault(key, defaultValue);
    }

    public boolean contains(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            return super.contains(plugin.getName() + ":" + key);
        }
        return super.contains(key);
    }

    public void remove(String key) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            super.remove(plugin.getName() + ":" + key);
        } else {
            super.remove(key);
        }
    }

    public void compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        if (plugin != null) {
            super.compute(plugin.getName() + ":" + key, remappingFunction);
        } else {
            super.compute(key, remappingFunction);
        }
    }
}

