/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.scheduler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.plugin.Plugin;
import top.focess.scheduler.Callback;
import top.focess.scheduler.CatchExceptionHandler;
import top.focess.scheduler.Scheduler;
import top.focess.scheduler.Task;

public class AScheduler
implements Scheduler {
    private static final Map<Plugin, List<Scheduler>> PLUGIN_SCHEDULER_MAP = Maps.newConcurrentMap();
    private final Plugin plugin;
    private final Scheduler scheduler;

    public AScheduler(Plugin plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.scheduler.setUncaughtExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-scheduler-uncaught", e, this.getName()));
        this.scheduler.setCatchExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-scheduler", e, this.getName()));
        PLUGIN_SCHEDULER_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newCopyOnWriteArrayList();
            }
            v.add(this);
            return v;
        });
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Task run(Runnable runnable, Duration delay) {
        return this.scheduler.run(runnable, delay);
    }

    public Task run(Runnable runnable, Duration duration, String name) {
        return this.scheduler.run(runnable, duration, name);
    }

    public Task runTimer(Runnable runnable, Duration delay, Duration period) {
        return this.scheduler.runTimer(runnable, delay, period);
    }

    public Task runTimer(Runnable runnable, Duration delay, Duration period, String name) {
        return this.scheduler.runTimer(runnable, delay, period, name);
    }

    public <V> Callback<V> submit(Callable<V> callable, Duration delay) {
        return this.scheduler.submit(callable, delay);
    }

    public <V> Callback<V> submit(Callable<V> callable, Duration duration, String name) {
        return this.scheduler.submit(callable, duration, name);
    }

    public void cancelAll() {
        this.scheduler.cancelAll();
    }

    public String getName() {
        return this.scheduler.getName();
    }

    public void close() {
        this.scheduler.close();
        PLUGIN_SCHEDULER_MAP.compute(this.plugin, (k, v) -> {
            if (v != null) {
                v.remove(this);
            }
            return v;
        });
    }

    public boolean isClosed() {
        return this.scheduler.isClosed();
    }

    public void closeNow() {
        this.scheduler.closeNow();
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.scheduler.setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Nullable
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.scheduler.getUncaughtExceptionHandler();
    }

    @Nullable
    public CatchExceptionHandler getCatchExceptionHandler() {
        return this.scheduler.getCatchExceptionHandler();
    }

    public void setCatchExceptionHandler(CatchExceptionHandler catchExceptionHandler) {
        this.scheduler.setCatchExceptionHandler(catchExceptionHandler);
    }

    public @UnmodifiableView List<Task> getRemainingTasks() {
        return this.scheduler.getRemainingTasks();
    }

    public static void close(Plugin plugin) {
        for (Scheduler scheduler : PLUGIN_SCHEDULER_MAP.getOrDefault(plugin, Lists.newCopyOnWriteArrayList())) {
            scheduler.close();
        }
        PLUGIN_SCHEDULER_MAP.remove(plugin);
    }

    public static boolean closeAll() {
        boolean ret = false;
        for (Plugin plugin : PLUGIN_SCHEDULER_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            AScheduler.close(plugin);
        }
        return ret;
    }
}

