/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import top.focess.command.DataCollection;
import top.focess.command.DataConverter;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.plugin.Plugin;

public class DataCollection {
    private static final Map<Plugin, List<DataConverter<?>>> PLUGIN_DATA_CONVERTER_MAP = Maps.newConcurrentMap();

    public static void register(Plugin plugin, DataConverter<?> dataConverter, DataCollection.BufferGetter bufferGetter) {
        PLUGIN_DATA_CONVERTER_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(dataConverter);
            return v;
        });
        top.focess.command.DataCollection.register(dataConverter, (DataCollection.BufferGetter)bufferGetter);
    }

    public static void unregister(DataConverter<?> dataConverter) {
        top.focess.command.DataCollection.unregister(dataConverter);
    }

    public static void unregister(Plugin plugin) {
        for (DataConverter dataConverter : (List)PLUGIN_DATA_CONVERTER_MAP.getOrDefault(plugin, Lists.newArrayList())) {
            DataCollection.unregister(dataConverter);
        }
        PLUGIN_DATA_CONVERTER_MAP.remove(plugin);
    }

    public static boolean unregisterAll() {
        boolean ret = false;
        for (Plugin plugin : PLUGIN_DATA_CONVERTER_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            DataCollection.unregister(plugin);
        }
        PLUGIN_DATA_CONVERTER_MAP.clear();
        return ret;
    }
}

