/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.BotLoginException;
import top.focess.qq.api.bot.contact.Friend;
import top.focess.qq.api.bot.contact.Group;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.bot.contact.SimpleFriend;
import top.focess.qq.core.bot.contact.SimpleGroup;

public class SimpleBot
implements top.focess.qq.api.bot.Bot {
    private final long username;
    private final String password;
    private final Plugin plugin;
    private Bot nativeBot;

    public SimpleBot(long username, String password, Bot bot, Plugin plugin) {
        this.username = username;
        this.password = password;
        this.nativeBot = bot;
        this.plugin = plugin;
    }

    @Override
    public Bot getNativeBot() {
        return this.nativeBot;
    }

    public void setNativeBot(Bot nativeBot) {
        this.nativeBot = nativeBot;
    }

    @Override
    public boolean relogin() throws BotLoginException {
        return FocessQQ.getBotManager().relogin(this);
    }

    @Override
    public boolean login() throws BotLoginException {
        return FocessQQ.getBotManager().login(this);
    }

    @Override
    public boolean logout() {
        return FocessQQ.getBotManager().logout(this);
    }

    @Override
    public @NonNull Friend getFriendOrFail(long id) {
        return Objects.requireNonNull(SimpleFriend.get((top.focess.qq.api.bot.Bot)this, this.nativeBot.getFriendOrFail(id)));
    }

    @Override
    public @NonNull Group getGroupOrFail(long id) {
        return Objects.requireNonNull(SimpleGroup.get((top.focess.qq.api.bot.Bot)this, this.nativeBot.getGroupOrFail(id)));
    }

    @Override
    public @Nullable Group getGroup(long id) {
        return SimpleGroup.get((top.focess.qq.api.bot.Bot)this, this.nativeBot.getGroup(id));
    }

    @Override
    public @Nullable Friend getFriend(long id) {
        return SimpleFriend.get((top.focess.qq.api.bot.Bot)this, this.nativeBot.getFriend(id));
    }

    @Override
    @NotNull
    public @UnmodifiableView List<Friend> getFriends() {
        return this.nativeBot.getFriends().stream().map(i -> Objects.requireNonNull(SimpleFriend.get((top.focess.qq.api.bot.Bot)this, i))).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public @UnmodifiableView List<Group> getGroups() {
        return this.nativeBot.getGroups().stream().map(i -> Objects.requireNonNull(SimpleGroup.get((top.focess.qq.api.bot.Bot)this, i))).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isOnline() {
        return this.nativeBot.isOnline();
    }

    @Override
    @NotNull
    public Friend getAsFriend() {
        return Objects.requireNonNull(SimpleFriend.get((top.focess.qq.api.bot.Bot)this, this.nativeBot.getAsFriend()));
    }

    @Override
    public long getId() {
        return this.nativeBot.getId();
    }

    @Override
    public boolean isDefaultBot() {
        return FocessQQ.getBot().equals(this);
    }

    public long getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBot simpleBot = (SimpleBot)o;
        return Objects.equals(this.nativeBot, simpleBot.nativeBot);
    }

    public int hashCode() {
        return this.nativeBot != null ? this.nativeBot.hashCode() : 0;
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isAdministrator() {
        if (FocessQQ.getAdministratorId() == null) {
            return false;
        }
        return this.getId() == FocessQQ.getAdministratorId().longValue();
    }
}

