/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.CommandResult;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.SpecialArgumentComplexHandler;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.scheduler.Callback;
import top.focess.scheduler.Scheduler;
import top.focess.util.Pair;

public class CommandLine {
    private static final AtomicInteger COMMAND_ID = new AtomicInteger();
    private static final Map<String, SpecialArgumentComplexHandler> SPECIAL_ARGUMENT_HANDLERS = Maps.newConcurrentMap();
    private static final Map<Plugin, List<Pair<String, SpecialArgumentComplexHandler>>> PLUGIN_SPECIAL_ARGUMENT_MAP = Maps.newConcurrentMap();
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 7, false, "CommandLine");

    @NotNull
    public static Future<CommandResult> exec(String command) {
        return CommandLine.exec(CommandSender.CONSOLE, command);
    }

    @NotNull
    public static Future<CommandResult> exec(CommandSender sender, String command) {
        return CommandLine.exec(sender, command, sender.getIOHandler());
    }

    @NotNull
    public static Future<CommandResult> exec(CommandSender sender, String command, IOHandler ioHandler) {
        List<String> args;
        int id = COMMAND_ID.getAndIncrement();
        FocessQQ.getLogger().debugLang("command-line-exec", sender.toString(), command, id);
        if (sender == CommandSender.CONSOLE) {
            FocessQQ.getLogger().consoleInput(command);
        }
        if ((args = CommandLine.splitCommand(command)).size() == 0) {
            return CompletableFuture.completedFuture(CommandResult.NONE);
        }
        String name = args.get(0);
        args.remove(0);
        return CommandLine.exec0(sender, name, args.toArray(new String[0]), ioHandler, command, id);
    }

    @NotNull
    public static List<String> splitCommand(@NotNull String command) {
        ArrayList args = Lists.newArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        boolean stack = false;
        boolean ignore = false;
        Character last = null;
        for (char c : command.toCharArray()) {
            if (ignore) {
                ignore = false;
                switch (c) {
                    case 'a': {
                        stringBuilder.append('\u0007');
                        break;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        break;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        break;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        break;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        break;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        break;
                    }
                    case 'v': {
                        stringBuilder.append('\u000b');
                        break;
                    }
                    case '0': {
                        stringBuilder.append('\u0000');
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                        break;
                    }
                }
            } else if (c == '\\') {
                ignore = true;
            } else if (c == ' ') {
                if (!stack) {
                    if (stringBuilder.length() > 0) {
                        args.add(stringBuilder.toString());
                        stringBuilder.delete(0, stringBuilder.length());
                    }
                } else {
                    stringBuilder.append(' ');
                }
            } else if (c == '\"') {
                stack = !stack;
            } else if (c == '@' && !stack && last != null && last.charValue() == ' ') {
                stringBuilder.append('\"');
                stringBuilder.append('@');
            } else {
                stringBuilder.append(c);
            }
            last = Character.valueOf(c);
        }
        if (stringBuilder.length() != 0) {
            args.add(stringBuilder.toString());
        }
        return args;
    }

    @NotNull
    @Contract(value="_ -> new")
    private static Pair<String, String[]> splitSpecialArgument(@NotNull String argument) {
        int leftIndex = argument.indexOf(40);
        if (leftIndex == -1 || !argument.endsWith(")")) {
            return new Pair((Object)argument, (Object)new String[0]);
        }
        String name = argument.substring(0, leftIndex);
        String[] args = argument.substring(leftIndex + 1, argument.length() - 1).split(",");
        return new Pair((Object)name, (Object)args);
    }

    private static Future<CommandResult> exec0(CommandSender sender, String command, String[] args, IOHandler ioHandler, String rawCommand, int id) {
        FocessQQ.getLogger().debugLang("command-pre-exec", sender.toString(), command, Arrays.toString(args), id);
        boolean flag = false;
        Callback ret = CompletableFuture.completedFuture(CommandResult.NONE);
        for (Command com : Command.getCommands()) {
            if (!com.getAliases().stream().anyMatch(i -> i.equalsIgnoreCase(command)) && !com.getName().equalsIgnoreCase(command)) continue;
            FocessQQ.getLogger().debugLang("command-before-special-handler", sender.toString(), command, Arrays.toString(args), id);
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (!args[i2].startsWith("\"@")) continue;
                String h = args[i2].substring(2);
                Pair<String, String[]> pair = CommandLine.splitSpecialArgument(h);
                String head = (String)pair.getKey();
                String[] values = (String[])pair.getValue();
                args[i2] = SPECIAL_ARGUMENT_HANDLERS.containsKey(head) ? SPECIAL_ARGUMENT_HANDLERS.get(head).handle(head, sender, com, args, i2, values) : (SPECIAL_ARGUMENT_HANDLERS.containsKey(com.getPlugin().getName() + ":" + head) ? SPECIAL_ARGUMENT_HANDLERS.get(com.getPlugin().getName() + ":" + head).handle(head, sender, com, args, i2, values) : args[i2].substring(1));
            }
            FocessQQ.getLogger().debugLang("command-after-special-handler", sender.toString(), command, Arrays.toString(args), id);
            flag = true;
            ret = EXECUTOR.submit(() -> {
                try {
                    CommandResult result = com.execute(sender, args, ioHandler, id, rawCommand);
                    FocessQQ.getLogger().debugLang("command-after-exec", sender.toString(), command, Arrays.toString(args), result.toString(), id);
                    return result;
                }
                catch (Exception e) {
                    ioHandler.outputLang("command-execute-exception", e.getMessage());
                    FocessQQ.getLogger().thrLang("exception-command-execute", e, new Object[0]);
                    return CommandResult.REFUSE_EXCEPTION;
                }
            }, "execute-" + command + "-with-" + id, exception -> {
                Throwable e = exception.getCause();
                ioHandler.outputLang("command-execute-exception", e.getMessage());
                FocessQQ.getLogger().thrLang("exception-command-execute", e, new Object[0]);
                return CommandResult.REFUSE_EXCEPTION;
            });
            break;
        }
        if (!flag && sender == CommandSender.CONSOLE) {
            ioHandler.outputLang("unknown-command", command);
        }
        return ret;
    }

    public static void register(Plugin plugin, String name, SpecialArgumentComplexHandler handler) {
        PLUGIN_SPECIAL_ARGUMENT_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            String n = plugin == FocessQQ.getMainPlugin() ? name : plugin.getName() + ":" + name;
            v.removeIf(i -> ((String)i.getKey()).equals(n));
            v.add(Pair.of((Object)n, (Object)handler));
            SPECIAL_ARGUMENT_HANDLERS.put(n, handler);
            return v;
        });
    }

    public static void unregister(SpecialArgumentComplexHandler handler) {
        PLUGIN_SPECIAL_ARGUMENT_MAP.forEach((k, v) -> v.removeIf(i -> i.getRight() == handler));
        SPECIAL_ARGUMENT_HANDLERS.forEach((k, v) -> {
            if (v == handler) {
                SPECIAL_ARGUMENT_HANDLERS.remove(k);
            }
        });
    }

    public static void unregister(Plugin plugin, String name) {
        PLUGIN_SPECIAL_ARGUMENT_MAP.computeIfPresent(plugin, (k, v) -> {
            v.removeIf(i -> ((String)i.getLeft()).equals(name));
            return v;
        });
        SPECIAL_ARGUMENT_HANDLERS.remove(name);
    }

    public static void unregister(Plugin plugin) {
        for (Pair<String, SpecialArgumentComplexHandler> pair : PLUGIN_SPECIAL_ARGUMENT_MAP.getOrDefault(plugin, Lists.newArrayList())) {
            SPECIAL_ARGUMENT_HANDLERS.remove(pair.getLeft());
        }
        PLUGIN_SPECIAL_ARGUMENT_MAP.remove(plugin);
    }

    public static boolean unregisterAll() {
        boolean flag = false;
        for (Plugin plugin : PLUGIN_SPECIAL_ARGUMENT_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                flag = true;
            }
            CommandLine.unregister(plugin);
        }
        return flag;
    }
}

