/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.util;

import java.time.Duration;
import java.util.Arrays;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.focess.command.DataConverter;
import top.focess.command.InputTimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.listeners.ConsoleListener;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;
import top.focess.scheduler.Scheduler;

public abstract class IOHandler
extends top.focess.command.IOHandler {
    protected static final Scheduler SCHEDULER = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin(), "Input");
    private static final Scheduler ASYNC_SCHEDULER = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 5, true, "IOHandler");
    private static volatile IOHandler CONSOLE_IO_HANDLER = new IOHandler(){

        public void output(@NotNull String output) {
            String[] messages = output.split("\n");
            Arrays.stream(messages).forEachOrdered(FocessQQ.getLogger()::info);
        }

        public synchronized boolean hasInput(boolean flag) {
            ConsoleListener.registerInputListener(this, SCHEDULER.run(() -> this.input(null), Duration.ofMinutes(10L), "input-10-min"));
            return super.hasInput(flag);
        }

        @Override
        public synchronized boolean hasInput(boolean flag, int seconds) {
            ConsoleListener.registerInputListener(this, SCHEDULER.run(() -> this.input(null), Duration.ofSeconds(seconds), "input-" + seconds + "-sec"));
            return super.hasInput(flag);
        }
    };

    @Nullable
    public <T> T input(DataConverter<T> dataConverter) throws InputTimeoutException {
        String input = this.input();
        if (dataConverter.accept(input)) {
            return (T)dataConverter.convert(input);
        }
        return null;
    }

    public static IOHandler getConsoleIoHandler() {
        return CONSOLE_IO_HANDLER;
    }

    public static void setConsoleIoHandler(IOHandler consoleIoHandler) {
        CONSOLE_IO_HANDLER = consoleIoHandler;
    }

    public void async(Consumer<IOHandler> consumer) {
        ASYNC_SCHEDULER.run(() -> consumer.accept(this), "async");
    }

    public void outputLang(String key, Object ... objects) {
        this.output(String.format(PluginCoreClassLoader.getClassLoadedByOrDefault(MethodCaller.getCallerClass()).getLangConfig().get(key), objects));
    }

    public abstract boolean hasInput(boolean var1, int var2);
}

