/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.command.data;

import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.command.data.DataBuffer;
import top.focess.command.data.StringBuffer;
import top.focess.qq.api.plugin.Plugin;

public class PluginBuffer
extends DataBuffer<Plugin> {
    private final StringBuffer stringBuffer;

    private PluginBuffer(int size) {
        this.stringBuffer = StringBuffer.allocate((int)size);
    }

    @NotNull
    @Contract(value="_ -> new")
    public static PluginBuffer allocate(int size) {
        return new PluginBuffer(size);
    }

    public void flip() {
        this.stringBuffer.flip();
    }

    public void put(@NotNull Plugin plugin) {
        this.stringBuffer.put(plugin.getName());
    }

    @NotNull
    public Plugin get() {
        String name = this.stringBuffer.get();
        try {
            return Objects.requireNonNull(Plugin.getPlugin(name));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Plugin: " + name + " is not found");
        }
    }

    @NotNull
    public Plugin get(int index) {
        String name = this.stringBuffer.get(index);
        try {
            return Objects.requireNonNull(Plugin.getPlugin(name));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Plugin: " + name + " is not found");
        }
    }
}

