/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot.mirai;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.ContactList;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.NormalMember;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.message.data.PlainText;
import net.mamoe.mirai.utils.ExternalResource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.command.CommandPermission;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.bot.BotProtocol;
import top.focess.qq.api.bot.contact.Member;
import top.focess.qq.api.bot.contact.Speaker;
import top.focess.qq.api.bot.contact.Stranger;
import top.focess.qq.api.bot.contact.Transmitter;
import top.focess.qq.api.bot.message.Audio;
import top.focess.qq.api.bot.message.Image;
import top.focess.qq.api.bot.message.TextMessage;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.bot.QQBot;
import top.focess.qq.core.bot.contact.SimpleFriend;
import top.focess.qq.core.bot.contact.SimpleGroup;
import top.focess.qq.core.bot.contact.SimpleMember;
import top.focess.qq.core.bot.contact.SimpleOtherClient;
import top.focess.qq.core.bot.contact.SimpleStranger;
import top.focess.qq.core.bot.mirai.message.MiraiAudio;
import top.focess.qq.core.bot.mirai.message.MiraiImage;
import top.focess.qq.core.bot.mirai.message.MiraiMessage;

public class MiraiBot
extends QQBot {
    private final Map<Long, top.focess.qq.api.bot.contact.Friend> friendMap = Maps.newHashMap();
    private final Map<Long, top.focess.qq.api.bot.contact.Group> groupMap = Maps.newHashMap();
    private final Map<Long, Member> memberMap = Maps.newHashMap();
    private final Map<Long, Stranger> strangerMap = Maps.newHashMap();
    private final Map<Long, top.focess.qq.api.bot.contact.OtherClient> clientMap = Maps.newHashMap();
    private Bot nativeBot;

    public MiraiBot(long username, String password, Bot bot, BotProtocol botProtocol, Plugin plugin, BotManager botManager) {
        super(username, password, plugin, botProtocol, botManager);
        this.nativeBot = bot;
    }

    public Bot getNativeBot() {
        return this.nativeBot;
    }

    public void setNativeBot(Bot nativeBot) {
        this.nativeBot = nativeBot;
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.Group getGroup(long id) {
        Group group = this.nativeBot.getGroup(id);
        if (group == null) {
            return null;
        }
        return this.groupMap.computeIfAbsent(id, i -> new SimpleGroup(this, group.getId(), group.getName(), group.getAvatarUrl()));
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.Friend getFriend(long id) {
        Friend friend = this.nativeBot.getFriend(id);
        if (friend == null) {
            return null;
        }
        return this.friendMap.computeIfAbsent(id, i -> new SimpleFriend(this, friend.getId(), friend.getRemark(), friend.getNick(), friend.getAvatarUrl()));
    }

    @Override
    @NotNull
    public @UnmodifiableView List<top.focess.qq.api.bot.contact.Friend> getFriends() {
        return this.nativeBot.getFriends().stream().map(friend -> new SimpleFriend(this, friend.getId(), friend.getRemark(), friend.getNick(), friend.getAvatarUrl())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public @UnmodifiableView List<top.focess.qq.api.bot.contact.Group> getGroups() {
        return this.nativeBot.getGroups().stream().map(group -> new SimpleGroup(this, group.getId(), group.getName(), group.getAvatarUrl())).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isOnline() {
        return this.nativeBot.isOnline();
    }

    @Override
    @NotNull
    public top.focess.qq.api.bot.contact.Friend getAsFriend() {
        Friend friend = this.nativeBot.getAsFriend();
        return this.friendMap.computeIfAbsent(this.getId(), i -> new SimpleFriend(this, friend.getId(), friend.getRemark(), friend.getNick(), friend.getAvatarUrl()));
    }

    @Override
    public void sendMessage(Transmitter transmitter, top.focess.qq.api.bot.message.Message message) {
        Message mess = MiraiBot.toMiraiMessage(message);
        if (transmitter instanceof top.focess.qq.api.bot.contact.Group) {
            Group group = this.nativeBot.getGroupOrFail(transmitter.getId());
            group.sendMessage(mess);
        } else if (transmitter instanceof top.focess.qq.api.bot.contact.Friend) {
            Friend friend = this.nativeBot.getFriendOrFail(transmitter.getId());
            friend.sendMessage(mess);
        } else if (transmitter instanceof Stranger) {
            net.mamoe.mirai.contact.Stranger stranger = this.nativeBot.getStrangerOrFail(transmitter.getId());
            stranger.sendMessage(mess);
        }
    }

    @Override
    public @Nullable Image uploadImage(Transmitter transmitter, InputStream resource) {
        if (transmitter instanceof top.focess.qq.api.bot.contact.Group) {
            Group group = this.nativeBot.getGroupOrFail(transmitter.getId());
            try {
                return new MiraiImage(group.uploadImage(ExternalResource.create((InputStream)resource)));
            }
            catch (IOException e) {
                return null;
            }
        }
        if (transmitter instanceof top.focess.qq.api.bot.contact.Friend) {
            Friend friend = this.nativeBot.getFriendOrFail(transmitter.getId());
            try {
                return new MiraiImage(friend.uploadImage(ExternalResource.create((InputStream)resource)));
            }
            catch (IOException e) {
                return null;
            }
        }
        if (transmitter instanceof Stranger) {
            net.mamoe.mirai.contact.Stranger stranger = this.nativeBot.getStrangerOrFail(transmitter.getId());
            try {
                return new MiraiImage(stranger.uploadImage(ExternalResource.create((InputStream)resource)));
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public @Nullable Audio uploadAudio(Speaker speaker, InputStream inputStream) {
        if (speaker instanceof top.focess.qq.api.bot.contact.Friend) {
            Friend friend = this.nativeBot.getFriendOrFail(speaker.getId());
            try {
                return new MiraiAudio(friend.uploadAudio(ExternalResource.create((InputStream)inputStream)));
            }
            catch (IOException e) {
                return null;
            }
        }
        if (speaker instanceof top.focess.qq.api.bot.contact.Group) {
            Group group = this.nativeBot.getGroupOrFail(speaker.getId());
            try {
                return new MiraiAudio(group.uploadAudio(ExternalResource.create((InputStream)inputStream)));
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public void deleteFriend(top.focess.qq.api.bot.contact.Friend friend) {
        this.nativeBot.getFriendOrFail(friend.getId()).delete();
        this.friendMap.remove(friend.getId());
    }

    @Override
    public void quitGroup(top.focess.qq.api.bot.contact.Group group) {
        this.nativeBot.getGroupOrFail(group.getId()).quit();
        this.groupMap.remove(group.getId());
    }

    @Override
    public @Nullable Member getMember(top.focess.qq.api.bot.contact.Group group, long id) {
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        NormalMember member = nativeGroup.get(id);
        if (member == null) {
            return null;
        }
        return this.memberMap.computeIfAbsent(id, arg_0 -> MiraiBot.lambda$getMember$5(group, (net.mamoe.mirai.contact.Member)member, arg_0));
    }

    @Override
    public Member getAsMember(top.focess.qq.api.bot.contact.Group group) {
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        NormalMember member = nativeGroup.getBotAsMember();
        return this.memberMap.computeIfAbsent(member.getId(), arg_0 -> MiraiBot.lambda$getAsMember$6(group, (net.mamoe.mirai.contact.Member)member, arg_0));
    }

    @Override
    public List<Member> getMembers(top.focess.qq.api.bot.contact.Group group) {
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        return nativeGroup.getMembers().stream().map(member -> this.memberMap.computeIfAbsent(member.getId(), i -> new SimpleMember(group, member.getId(), member.getRemark(), member.getNick(), member.getNameCard(), MiraiBot.toCommandPermission(member.getPermission())))).collect(Collectors.toList());
    }

    private static CommandPermission toCommandPermission(MemberPermission permission) {
        switch (permission) {
            case OWNER: {
                return CommandPermission.OWNER;
            }
            case ADMINISTRATOR: {
                return CommandPermission.ADMINISTRATOR;
            }
            case MEMBER: {
                return CommandPermission.MEMBER;
            }
        }
        throw new IllegalArgumentException("Unknown permission: " + permission);
    }

    private static Message toMiraiMessage(top.focess.qq.api.bot.message.Message message) {
        if (message instanceof MiraiMessage) {
            return ((MiraiMessage)message).getMessage();
        }
        if (message instanceof TextMessage) {
            return new PlainText(((TextMessage)message).getText());
        }
        throw new IllegalArgumentException("Unknown message type: " + message.getClass());
    }

    @Override
    public @Nullable Stranger getStranger(long id) {
        net.mamoe.mirai.contact.Stranger stranger = this.nativeBot.getStranger(id);
        if (stranger == null) {
            return null;
        }
        return this.strangerMap.computeIfAbsent(id, i -> new SimpleStranger(this, stranger.getId(), stranger.getRemark(), stranger.getNick()));
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.OtherClient getOtherClient(long id) {
        ContactList clients = this.nativeBot.getOtherClients();
        for (OtherClient client : clients) {
            if (client.getId() != id) continue;
            return this.clientMap.computeIfAbsent(id, i -> new SimpleOtherClient(this, client.getId(), client.getInfo().getDeviceName(), client.getInfo().getDeviceKind(), client.getInfo().getAppId()));
        }
        return null;
    }

    private static /* synthetic */ Member lambda$getAsMember$6(top.focess.qq.api.bot.contact.Group group, net.mamoe.mirai.contact.Member member, Long i) {
        return new SimpleMember(group, member.getId(), member.getRemark(), member.getNick(), member.getNameCard(), MiraiBot.toCommandPermission(member.getPermission()));
    }

    private static /* synthetic */ Member lambda$getMember$5(top.focess.qq.api.bot.contact.Group group, net.mamoe.mirai.contact.Member member, Long i) {
        return new SimpleMember(group, member.getId(), member.getRemark(), member.getNick(), member.getNameCard(), MiraiBot.toCommandPermission(member.getPermission()));
    }
}

