/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.event;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.schedule.Schedulers;
import top.focess.qq.core.debug.Section;
import top.focess.qq.core.permission.Permission;
import top.focess.scheduler.Scheduler;
import top.focess.scheduler.Task;

public class EventManager {
    private static final Scheduler SCHEDULER = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 10, false, "EventManager");
    private static final Map<Class<? extends Event>, ListenerHandler> LISTENER_HANDLER_MAP = Maps.newHashMap();

    private static <T> T cast(Object t) {
        return (T)t;
    }

    public static <T extends Event> void submit(T event) throws EventSubmitException {
        Permission.checkPermission(Permission.EVENT_SUBMIT);
        Task task = SCHEDULER.run(() -> {
            try {
                EventManager.submit((Class)EventManager.cast(event.getClass()), event);
            }
            catch (EventSubmitException e) {
                throw new EventSubmitRuntimeException(e);
            }
        }, "submit-" + event.getClass().getName());
        Section section = Section.startSection("event-submit", task, Duration.ofSeconds(10L));
        try {
            task.join();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            section.stop();
            if (e.getCause() instanceof EventSubmitRuntimeException) {
                throw (EventSubmitException)e.getCause().getCause();
            }
            FocessQQ.getLogger().debugLang("section-exception", section.getName(), e.getMessage());
        }
        section.stop();
    }

    private static <T extends Event> void submit(@NotNull Class<T> cls, T event) throws EventSubmitException {
        if (!Modifier.isAbstract(cls.getModifiers())) {
            ListenerHandler listenerHandler = LISTENER_HANDLER_MAP.get(cls);
            if (listenerHandler == null) {
                try {
                    Field field = cls.getDeclaredField("LISTENER_HANDLER");
                    boolean flag = field.canAccess(null);
                    field.setAccessible(true);
                    listenerHandler = (ListenerHandler)field.get(null);
                    field.setAccessible(flag);
                    LISTENER_HANDLER_MAP.put(cls, listenerHandler);
                }
                catch (Exception e) {
                    throw new EventSubmitException(event, "This event doesn't contain a LISTENER_HANDLER field.");
                }
            }
            listenerHandler.submit(event);
            Class<T> c = cls;
            while (!(c = c.getSuperclass()).equals(Event.class)) {
                EventManager.trySubmitOnce((Class)EventManager.cast(c), event);
            }
        } else {
            throw new EventSubmitException(event, "This event is an abstract class.");
        }
    }

    private static <T extends Event> void trySubmitOnce(Class<T> cls, T event) throws EventSubmitException {
        EventManager.submitOnce(cls, event);
    }

    private static <T extends Event> void submitOnce(@NotNull Class<T> cls, T event) throws EventSubmitException {
        ListenerHandler listenerHandler;
        if (!Modifier.isAbstract(cls.getModifiers())) {
            listenerHandler = LISTENER_HANDLER_MAP.get(cls);
            if (listenerHandler == null) {
                try {
                    Field field = cls.getDeclaredField("LISTENER_HANDLER");
                    boolean flag = field.canAccess(null);
                    field.setAccessible(true);
                    listenerHandler = (ListenerHandler)field.get(null);
                    field.setAccessible(flag);
                    LISTENER_HANDLER_MAP.put(cls, listenerHandler);
                }
                catch (Exception e) {
                    throw new EventSubmitException(event, "This event doesn't contain a LISTENER_HANDLER field.");
                }
            }
        } else {
            throw new EventSubmitException(event, "This event is an abstract class.");
        }
        listenerHandler.submit(event);
    }

    private static class EventSubmitRuntimeException
    extends RuntimeException {
        public EventSubmitRuntimeException(EventSubmitException e) {
            super(e);
        }
    }
}

