/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.event.Cancellable;
import top.focess.qq.api.event.Event;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;
import top.focess.util.Pair;

public class ListenerHandler {
    static final Map<Listener, Plugin> LISTENER_PLUGIN_MAP = Maps.newConcurrentMap();
    private static final List<ListenerHandler> LISTENER_HANDLER_LIST = Lists.newArrayList();
    private static final Map<Plugin, List<Listener>> PLUGIN_LISTENER_MAP = Maps.newConcurrentMap();
    private final List<Pair<Pair<Listener, Method>, EventHandler>> listeners = Lists.newCopyOnWriteArrayList();

    public ListenerHandler() {
        LISTENER_HANDLER_LIST.add(this);
    }

    public int size() {
        return this.listeners.size();
    }

    public static void unregister(Plugin plugin) {
        Permission.checkPermission(Permission.REMOVE_LISTENER);
        List<Listener> listeners = PLUGIN_LISTENER_MAP.getOrDefault(plugin, Lists.newArrayList());
        for (ListenerHandler handler : LISTENER_HANDLER_LIST) {
            for (Listener listener : listeners) {
                LISTENER_PLUGIN_MAP.remove(listener);
                handler.unregister(listener);
            }
        }
        PLUGIN_LISTENER_MAP.remove(plugin);
    }

    public static void unregister(Plugin plugin, Listener listener) {
        Permission.checkPermission(Permission.REMOVE_LISTENER);
        PLUGIN_LISTENER_MAP.computeIfPresent(plugin, (k, v) -> {
            v.remove(listener);
            return v;
        });
        for (ListenerHandler handler : LISTENER_HANDLER_LIST) {
            handler.unregister(listener);
        }
        LISTENER_PLUGIN_MAP.remove(listener);
    }

    public static void register(Plugin plugin, Listener listener) {
        Permission.checkPermission(Permission.REGISTER_LISTENER);
        PLUGIN_LISTENER_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(listener);
            return v;
        });
        LISTENER_PLUGIN_MAP.put(listener, plugin);
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Class<?> eventClass;
            EventHandler handler = method.getAnnotation(EventHandler.class);
            if (handler == null || method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(eventClass = method.getParameterTypes()[0]) || Modifier.isAbstract(eventClass.getModifiers())) continue;
            try {
                Field field = eventClass.getDeclaredField("LISTENER_HANDLER");
                boolean flag = field.canAccess(null);
                field.setAccessible(true);
                ListenerHandler listenerHandler = (ListenerHandler)field.get(null);
                field.setAccessible(flag);
                listenerHandler.register(listener, method, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean unregisterAll() {
        Permission.checkPermission(Permission.REMOVE_LISTENER);
        boolean ret = false;
        for (Plugin plugin : PLUGIN_LISTENER_MAP.keySet()) {
            if (plugin != FocessQQ.getMainPlugin()) {
                ret = true;
            }
            ListenerHandler.unregister(plugin);
        }
        PLUGIN_LISTENER_MAP.clear();
        return ret;
    }

    public void unregister(Listener listener) {
        Permission.checkPermission(Permission.REMOVE_LISTENER);
        this.listeners.removeIf(i -> ((Listener)((Pair)i.getKey()).getKey()).equals(listener));
    }

    public <T extends Event> void register(Listener listener, Method method, EventHandler handler) {
        this.listeners.add((Pair<Pair<Listener, Method>, EventHandler>)Pair.of((Object)Pair.of((Object)listener, (Object)method), (Object)handler));
        this.listeners.sort(Comparator.comparing(pair -> ((EventHandler)pair.getValue()).priority().getPriority()));
    }

    public <T extends Event> void submit(T event) {
        this.listeners.forEach(i -> {
            if (event.isPrevent() && ((EventHandler)i.getValue()).notCallIfPrevented()) {
                return;
            }
            if (event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled() && ((EventHandler)i.getValue()).notCallIfCancelled()) {
                return;
            }
            Method method = (Method)((Pair)i.getKey()).getValue();
            try {
                method.setAccessible(true);
                method.invoke(((Pair)i.getKey()).getKey(), event);
            }
            catch (Exception e) {
                FocessQQ.getLogger().thrLang("exception-handle-event", e, event.getClass().getName());
            }
        });
    }
}

