/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.schedule;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.scheduler.AScheduler;
import top.focess.scheduler.FocessScheduler;
import top.focess.scheduler.Scheduler;
import top.focess.scheduler.ThreadPoolScheduler;

public class Schedulers {
    private Schedulers() {
    }

    @NotNull
    @Contract(value="_ -> new")
    public static Scheduler newFocessScheduler(@NotNull Plugin plugin) {
        Permission.checkPermission(Permission.SCHEDULER);
        return new AScheduler(plugin, (Scheduler)FocessScheduler.newPrefixFocessScheduler((String)plugin.getName()));
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static Scheduler newFocessScheduler(@NotNull Plugin plugin, @NotNull String name) {
        Permission.checkPermission(Permission.SCHEDULER);
        return new AScheduler(plugin, (Scheduler)new FocessScheduler(name));
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static Scheduler newThreadPoolScheduler(@NotNull Plugin plugin, int poolSize) {
        Permission.checkPermission(Permission.SCHEDULER);
        ThreadPoolScheduler scheduler = new ThreadPoolScheduler(plugin.getName(), poolSize);
        scheduler.setThreadUncaughtExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread-uncaught", e, t.getName()));
        scheduler.setThreadCatchExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread", e, new Object[0]));
        return new AScheduler(plugin, (Scheduler)scheduler);
    }

    @NotNull
    @Contract(value="_, _, _, _ -> new")
    public static Scheduler newThreadPoolScheduler(@NotNull Plugin plugin, int poolSize, boolean immediate, @NotNull String name) {
        Permission.checkPermission(Permission.SCHEDULER);
        ThreadPoolScheduler scheduler = new ThreadPoolScheduler(poolSize, immediate, name);
        scheduler.setThreadUncaughtExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread-uncaught", e, t.getName()));
        scheduler.setThreadCatchExceptionHandler((t, e) -> FocessQQ.getLogger().thrLang("exception-thread-pool-scheduler-thread", e, new Object[0]));
        return new AScheduler(plugin, (Scheduler)scheduler);
    }

    public static void close(Plugin plugin) {
        Permission.checkPermission(Permission.REMOVE_SCHEDULER);
        AScheduler.close(plugin);
    }

    public static boolean closeAll() {
        Permission.checkPermission(Permission.REMOVE_SCHEDULER);
        return AScheduler.closeAll();
    }
}

