/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import top.focess.command.InputTimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.core.permission.Permission;
import top.focess.util.option.Option;
import top.focess.util.version.Version;
import top.focess.util.yaml.YamlConfiguration;
import top.focess.util.yaml.YamlConfigurationSection;

public class PluginDescription {
    private final String main;
    private final List<String> dependencies;
    private final List<String> softDependencies;
    private final String author;
    private final Version version;
    private final String name;
    private final Version requireVersion;
    private final Version limitVersion;
    private final Map<Permission, Boolean> permissions = Maps.newHashMap();
    private static YamlConfiguration permissionsConfig;

    public Map<Permission, Boolean> getPermissions() {
        return this.permissions;
    }

    public PluginDescription(@NotNull YamlConfiguration pluginConfig) {
        this.main = (String)pluginConfig.get("main");
        this.author = (String)pluginConfig.getOrDefault("author", (Object)"");
        this.dependencies = pluginConfig.getListOrEmpty("depend");
        this.softDependencies = pluginConfig.getListOrEmpty("soft-depend");
        this.version = new Version((String)pluginConfig.getOrDefault("version", (Object)"1.0.0"));
        this.name = (String)pluginConfig.getOrDefault("name", (Object)"");
        this.requireVersion = new Version((String)pluginConfig.getOrDefault("require-version", (Object)FocessQQ.getVersion().toString()));
        this.limitVersion = new Version((String)pluginConfig.getOrDefault("limit-version", (Object)FocessQQ.getVersion().toString()));
        YamlConfigurationSection permissionsStatus = permissionsConfig.getSection(this.name);
        List yeses = permissionsStatus.getListOrEmpty("yes");
        List nos = permissionsStatus.getListOrEmpty("no");
        CopyOnWriteArrayList permissions = Lists.newCopyOnWriteArrayList((Iterable)pluginConfig.getListOrEmpty("permissions"));
        for (String permission : permissions) {
            Permission per = Permission.getPermission(permission);
            if (per == null) {
                permissions.remove(permission);
                continue;
            }
            if (yeses.contains(permission)) {
                this.permissions.put(per, true);
                permissions.remove(permission);
                continue;
            }
            if (nos.contains(permission)) {
                this.permissions.put(per, false);
                permissions.remove(permission);
                continue;
            }
            if (per.getPriority() <= 1) {
                this.permissions.put(per, true);
                permissions.remove(permission);
                continue;
            }
            if (per.getPriority() < 4) continue;
            this.permissions.put(per, false);
            permissions.remove(permission);
        }
        if (permissions.isEmpty()) {
            return;
        }
        Option option = FocessQQ.getOptions().get("allowAll");
        Boolean isAll = null;
        if (option != null) {
            isAll = true;
        } else {
            IOHandler.getConsoleIoHandler().outputLang("permission-before-request", this.name, permissions.size());
            try {
                IOHandler.getConsoleIoHandler().hasInput(10);
                String yes = IOHandler.getConsoleIoHandler().input();
                if (yes.equalsIgnoreCase("yes")) {
                    isAll = true;
                } else if (yes.equalsIgnoreCase("no")) {
                    isAll = false;
                }
            }
            catch (InputTimeoutException ignored) {
                IOHandler.getConsoleIoHandler().outputLang("permission-timeout", new Object[0]);
            }
        }
        for (String permission : permissions) {
            if (isAll == null) {
                IOHandler.getConsoleIoHandler().outputLang("permission-request", this.name, permission);
                try {
                    IOHandler.getConsoleIoHandler().hasInput(10);
                    String yes = IOHandler.getConsoleIoHandler().input();
                    if (yes.equalsIgnoreCase("yes")) {
                        yeses.add(permission);
                        this.permissions.put(Permission.getPermission(permission), true);
                        continue;
                    }
                    if (!yes.equalsIgnoreCase("no")) continue;
                    nos.add(permission);
                    this.permissions.put(Permission.getPermission(permission), false);
                }
                catch (InputTimeoutException ignored) {
                    IOHandler.getConsoleIoHandler().outputLang("permission-timeout", new Object[0]);
                }
                continue;
            }
            if (isAll.booleanValue()) {
                yeses.add(permission);
            } else {
                nos.add(permission);
            }
            this.permissions.put(Permission.getPermission(permission), isAll);
        }
        permissionsStatus.setList("yes", yeses);
        permissionsStatus.setList("no", nos);
        permissionsConfig.save(new File("plugins/Main", "permissions.yml"));
    }

    PluginDescription() {
        this.main = FocessQQ.MainPlugin.class.getName();
        this.author = "MidCoard";
        this.dependencies = Lists.newArrayList();
        this.softDependencies = Lists.newArrayList();
        this.version = FocessQQ.getVersion();
        this.name = "Main";
        this.requireVersion = FocessQQ.getVersion();
        this.limitVersion = FocessQQ.getVersion();
        this.permissions.put(Permission.ALL, true);
        try {
            File file = new File("plugins/Main", "permissions.yml");
            if (!file.exists()) {
                file.createNewFile();
            }
            permissionsConfig = YamlConfiguration.loadFile((File)file);
        }
        catch (IOException e) {
            permissionsConfig = new YamlConfiguration(null);
        }
    }

    public String getMain() {
        return this.main;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public List<String> getSoftDependencies() {
        return this.softDependencies;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public Version getVersion() {
        return this.version;
    }

    public Version getRequireVersion() {
        return this.requireVersion;
    }

    public Version getLimitVersion() {
        return this.limitVersion;
    }

    public boolean hasPermission(Permission permission) {
        for (Permission p : this.permissions.keySet()) {
            if (!this.permissions.get((Object)p).booleanValue() || !p.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean addPermission(Permission permission) {
        this.permissions.put(permission, true);
        YamlConfigurationSection permissionsStatus = permissionsConfig.getSection(this.name);
        List yeses = permissionsStatus.getListOrEmpty("yes");
        List nos = permissionsStatus.getListOrEmpty("no");
        if (yeses.contains(permission.getName())) {
            return false;
        }
        nos.remove(permission.getName());
        yeses.add(permission.getName());
        permissionsConfig.save(new File("plugins/Main", "permissions.yml"));
        return true;
    }
}

