/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot.mirai;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.contact.ContactList;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.MemberPermission;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.message.data.Message;
import net.mamoe.mirai.utils.ExternalResource;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.command.CommandPermission;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.bot.BotProtocol;
import top.focess.qq.api.bot.contact.Member;
import top.focess.qq.api.bot.contact.Speaker;
import top.focess.qq.api.bot.contact.Stranger;
import top.focess.qq.api.bot.contact.Transmitter;
import top.focess.qq.api.bot.message.Audio;
import top.focess.qq.api.bot.message.Image;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.bot.QQBot;
import top.focess.qq.core.bot.contact.SimpleFriend;
import top.focess.qq.core.bot.contact.SimpleGroup;
import top.focess.qq.core.bot.contact.SimpleMember;
import top.focess.qq.core.bot.contact.SimpleOtherClient;
import top.focess.qq.core.bot.contact.SimpleStranger;
import top.focess.qq.core.bot.mirai.message.MiraiAudio;
import top.focess.qq.core.bot.mirai.message.MiraiImage;
import top.focess.qq.core.bot.mirai.message.MiraiMessageUtil;
import top.focess.util.Pair;

public class MiraiBot
extends QQBot {
    private final Map<Long, top.focess.qq.api.bot.contact.Friend> friendMap = Maps.newHashMap();
    private final Map<Long, top.focess.qq.api.bot.contact.Group> groupMap = Maps.newHashMap();
    private final Map<Pair<Long, Long>, Member> memberMap = Maps.newHashMap();
    private final Map<Long, Stranger> strangerMap = Maps.newHashMap();
    private final Map<Long, top.focess.qq.api.bot.contact.OtherClient> clientMap = Maps.newHashMap();
    private Bot nativeBot;

    public MiraiBot(long username, String password, Bot bot, BotProtocol botProtocol, Plugin plugin, BotManager botManager) {
        super(username, password, plugin, botProtocol, botManager);
        this.nativeBot = bot;
    }

    public Bot getNativeBot() {
        return this.nativeBot;
    }

    public void setNativeBot(Bot nativeBot) {
        this.nativeBot = nativeBot;
    }

    public @Nullable top.focess.qq.api.bot.contact.Group getGroup(@Nullable Group group) {
        if (group == null || group.getBot().getId() != this.getId()) {
            return null;
        }
        return this.groupMap.computeIfAbsent(group.getId(), i -> new SimpleGroup(this, group.getId(), group.getName(), group.getAvatarUrl()));
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.Group getGroup(long id) {
        if (this.groupMap.containsKey(id)) {
            return this.groupMap.get(id);
        }
        return this.getGroup(this.nativeBot.getGroup(id));
    }

    public @Nullable top.focess.qq.api.bot.contact.Friend getFriend(@Nullable Friend friend) {
        if (friend == null || friend.getBot().getId() != this.getId()) {
            return null;
        }
        return this.friendMap.computeIfAbsent(friend.getId(), i -> new SimpleFriend(this, friend.getId(), friend.getRemark(), friend.getNick(), friend.getAvatarUrl()));
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.Friend getFriend(long id) {
        if (this.friendMap.containsKey(id)) {
            return this.friendMap.get(id);
        }
        return this.getFriend(this.nativeBot.getFriend(id));
    }

    @Override
    @NotNull
    public @UnmodifiableView List<top.focess.qq.api.bot.contact.Friend> getFriends() {
        return this.nativeBot.getFriends().stream().map(this::getFriend).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    @NotNull
    public @UnmodifiableView List<top.focess.qq.api.bot.contact.Group> getGroups() {
        return this.nativeBot.getGroups().stream().map(this::getGroup).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public boolean isOnline() {
        return this.nativeBot.isOnline();
    }

    @Override
    @NotNull
    public top.focess.qq.api.bot.contact.Friend getAsFriend() {
        if (this.friendMap.containsKey(this.getId())) {
            return this.friendMap.get(this.getId());
        }
        return Objects.requireNonNull(this.getFriend(this.nativeBot.getAsFriend()));
    }

    @Override
    public void sendMessage(Transmitter transmitter, top.focess.qq.api.bot.message.Message message) {
        Message mess = MiraiMessageUtil.toNativeMessage(message);
        if (mess == null) {
            return;
        }
        if (transmitter instanceof top.focess.qq.api.bot.contact.Group) {
            Group group = this.nativeBot.getGroupOrFail(transmitter.getId());
            group.sendMessage(mess);
        } else if (transmitter instanceof top.focess.qq.api.bot.contact.Friend) {
            Friend friend = this.nativeBot.getFriendOrFail(transmitter.getId());
            friend.sendMessage(mess);
        } else if (transmitter instanceof Stranger) {
            net.mamoe.mirai.contact.Stranger stranger = this.nativeBot.getStrangerOrFail(transmitter.getId());
            stranger.sendMessage(mess);
        }
    }

    @Override
    public @Nullable Image uploadImage(Transmitter transmitter, InputStream resource) {
        MiraiImage miraiImage;
        block13: {
            ExternalResource externalResource = ExternalResource.create((InputStream)resource);
            try {
                MiraiImage ret = null;
                if (transmitter instanceof top.focess.qq.api.bot.contact.Group) {
                    Group group = this.nativeBot.getGroupOrFail(transmitter.getId());
                    ret = new MiraiImage(group.uploadImage(externalResource));
                } else if (transmitter instanceof top.focess.qq.api.bot.contact.Friend) {
                    Friend friend = this.nativeBot.getFriendOrFail(transmitter.getId());
                    ret = new MiraiImage(friend.uploadImage(externalResource));
                } else if (transmitter instanceof Stranger) {
                    net.mamoe.mirai.contact.Stranger stranger = this.nativeBot.getStrangerOrFail(transmitter.getId());
                    ret = new MiraiImage(stranger.uploadImage(externalResource));
                }
                miraiImage = ret;
                if (externalResource == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (externalResource != null) {
                        try {
                            externalResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            externalResource.close();
        }
        return miraiImage;
    }

    @Override
    public @Nullable Audio uploadAudio(Speaker speaker, InputStream inputStream) {
        MiraiAudio miraiAudio;
        block11: {
            ExternalResource externalResource = ExternalResource.create((InputStream)inputStream);
            try {
                MiraiAudio ret = null;
                if (speaker instanceof top.focess.qq.api.bot.contact.Friend) {
                    Friend friend = this.nativeBot.getFriendOrFail(speaker.getId());
                    ret = new MiraiAudio(friend.uploadAudio(externalResource));
                } else if (speaker instanceof top.focess.qq.api.bot.contact.Group) {
                    Group group = this.nativeBot.getGroupOrFail(speaker.getId());
                    ret = new MiraiAudio(group.uploadAudio(externalResource));
                }
                miraiAudio = ret;
                if (externalResource == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (externalResource != null) {
                        try {
                            externalResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            externalResource.close();
        }
        return miraiAudio;
    }

    @Override
    public void deleteFriend(@NotNull top.focess.qq.api.bot.contact.Friend friend) {
        this.nativeBot.getFriendOrFail(friend.getId()).delete();
        this.friendMap.remove(friend.getId());
    }

    @Override
    public void quitGroup(@NotNull top.focess.qq.api.bot.contact.Group group) {
        this.nativeBot.getGroupOrFail(group.getId()).quit();
        this.groupMap.remove(group.getId());
    }

    @Override
    public @Nullable Member getMember(top.focess.qq.api.bot.contact.Group group, long id) {
        if (this.memberMap.containsKey(Pair.of((Object)group.getId(), (Object)id))) {
            return this.memberMap.get(Pair.of((Object)group.getId(), (Object)id));
        }
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        return this.getMember((net.mamoe.mirai.contact.Member)nativeGroup.get(id));
    }

    @Override
    public @Nullable Member getAsMember(@NotNull top.focess.qq.api.bot.contact.Group group) {
        if (this.memberMap.containsKey(Pair.of((Object)group.getId(), (Object)this.getId()))) {
            return this.memberMap.get(Pair.of((Object)group.getId(), (Object)this.getId()));
        }
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        return this.getMember((net.mamoe.mirai.contact.Member)nativeGroup.getBotAsMember());
    }

    @Override
    public @UnmodifiableView List<Member> getMembers(@NotNull top.focess.qq.api.bot.contact.Group group) {
        Group nativeGroup = this.nativeBot.getGroupOrFail(group.getId());
        return nativeGroup.getMembers().stream().map(this::getMember).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    private static CommandPermission toCommandPermission(MemberPermission permission) {
        switch (permission) {
            case OWNER: {
                return CommandPermission.OWNER;
            }
            case ADMINISTRATOR: {
                return CommandPermission.ADMINISTRATOR;
            }
            case MEMBER: {
                return CommandPermission.MEMBER;
            }
        }
        throw new IllegalArgumentException("Unknown permission: " + permission);
    }

    @Override
    public @Nullable Stranger getStranger(long id) {
        if (this.strangerMap.containsKey(id)) {
            return this.strangerMap.get(id);
        }
        return this.getStranger(this.nativeBot.getStranger(id));
    }

    @Override
    public @Nullable top.focess.qq.api.bot.contact.OtherClient getOtherClient(long id) {
        if (this.clientMap.containsKey(id)) {
            return this.clientMap.get(id);
        }
        ContactList clients = this.nativeBot.getOtherClients();
        for (OtherClient client : clients) {
            if (client.getId() != id) continue;
            return this.clientMap.computeIfAbsent(id, i -> new SimpleOtherClient(this, client.getId(), client.getInfo().getDeviceName(), client.getInfo().getDeviceKind(), client.getInfo().getAppId()));
        }
        return null;
    }

    public @Nullable Member getMember(@Nullable net.mamoe.mirai.contact.Member sender) {
        if (sender == null || sender.getBot().getId() != this.getId()) {
            return null;
        }
        top.focess.qq.api.bot.contact.Group group = this.getGroup(sender.getGroup());
        if (group == null) {
            return null;
        }
        return this.memberMap.computeIfAbsent((Pair<Long, Long>)Pair.of((Object)group.getId(), (Object)sender.getId()), i -> new SimpleMember(group, sender.getId(), sender.getRemark(), sender.getNick(), sender.getNameCard(), MiraiBot.toCommandPermission(sender.getPermission())));
    }

    public @Nullable Stranger getStranger(@Nullable net.mamoe.mirai.contact.Stranger stranger) {
        if (stranger == null || stranger.getBot().getId() != this.getId()) {
            return null;
        }
        return this.strangerMap.computeIfAbsent(stranger.getId(), i -> new SimpleStranger(this, stranger.getId(), stranger.getRemark(), stranger.getNick()));
    }
}

