/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.focess.command.CommandArgument;
import top.focess.command.CommandResult;
import top.focess.command.InputTimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.bot.contact.Group;
import top.focess.qq.api.bot.message.Message;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandSender;

public class GroupCommand
extends Command {
    public GroupCommand() {
        super("group", new String[0]);
    }

    @Override
    public void init() {
        this.setExecutorPermission(i -> i.isAdministrator() || i.isConsole());
        this.addExecutor((sender, dataCollection, ioHandler) -> {
            long id = dataCollection.getLong();
            Bot bot = FocessQQ.getBotManager().getBot(id);
            if (bot == null) {
                ioHandler.outputLang("group-command-bot-not-found", id);
                return CommandResult.REFUSE;
            }
            if (!bot.getGroups().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder(FocessQQ.getLangConfig().get("group-command-list"));
                for (Group group : bot.getGroups()) {
                    stringBuilder.append(group.getName()).append("(").append(group.getId()).append("),");
                }
                ioHandler.output(stringBuilder.substring(0, stringBuilder.length() - 1));
            } else {
                ioHandler.outputLang("group-command-no-group", new Object[0]);
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"list"), CommandArgument.ofLong());
        this.addExecutor((sender, dataCollection, ioHandler) -> {
            long id = dataCollection.getLong();
            Bot bot = FocessQQ.getBotManager().getBot(id);
            if (bot == null) {
                ioHandler.outputLang("group-command-bot-not-found", id);
                return CommandResult.REFUSE;
            }
            long groupId = dataCollection.getLong();
            try {
                ioHandler.outputLang("group-command-input-one-message", new Object[0]);
                Message message = ioHandler.inputMessage();
                Group group = bot.getGroup(groupId);
                if (group == null) {
                    ioHandler.outputLang("group-command-group-not-found", groupId);
                    return CommandResult.REFUSE;
                }
                group.sendMessage(message);
                ioHandler.outputLang("group-command-send-success", groupId);
            }
            catch (InputTimeoutException exception) {
                ioHandler.outputLang("group-command-input-timeout", new Object[0]);
                return CommandResult.REFUSE;
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"send"), CommandArgument.ofLong(), CommandArgument.ofLong());
    }

    @Override
    @NotNull
    public List<String> usage(CommandSender sender) {
        return Lists.newArrayList((Object[])new String[]{"Use: group list <bot-id>", "Use: group send <bot-id> <group-id>"});
    }
}

