/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.listeners;

import com.google.common.collect.Queues;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.Future;
import top.focess.command.CommandResult;
import top.focess.command.InputTimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.event.EventHandler;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventPriority;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.chat.ConsoleChatEvent;
import top.focess.qq.api.event.message.ConsoleMessageEvent;
import top.focess.qq.api.scheduler.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.core.debug.Section;
import top.focess.scheduler.Scheduler;
import top.focess.scheduler.Task;
import top.focess.util.Pair;

public class ConsoleListener
implements Listener {
    public static final Queue<Pair<IOHandler, Task>> QUESTS = Queues.newLinkedBlockingQueue();
    private static final Scheduler EXECUTOR = Schedulers.newThreadPoolScheduler(FocessQQ.getMainPlugin(), 5, true, "ConsoleListener");

    public static void registerInputListener(IOHandler ioHandler, Task task) {
        QUESTS.offer((Pair<IOHandler, Task>)Pair.of((Object)((Object)ioHandler), (Object)task));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onConsoleChat(ConsoleChatEvent event) {
        Pair<IOHandler, Task> element;
        while ((element = QUESTS.poll()) != null) {
            if (!((Task)element.getValue()).cancel()) continue;
            ((IOHandler)((Object)element.getKey())).input(event.getMessage());
            return;
        }
        try {
            Future<CommandResult> ret = CommandLine.exec(event.getMessage().toString());
            EXECUTOR.run(() -> {
                Section section;
                block5: {
                    section = Section.startSection("command-console-exec", ret, Duration.ofMinutes(10L));
                    try {
                        if (ret.get() == CommandResult.NONE) {
                            ConsoleMessageEvent consoleMessageEvent = new ConsoleMessageEvent(event.getMessage());
                            try {
                                EventManager.submit(consoleMessageEvent);
                            }
                            catch (Exception e) {
                                FocessQQ.getLogger().thrLang("exception-submit-console-message-event", e, new Object[0]);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof InputTimeoutException) break block5;
                        FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
                    }
                }
                section.stop();
            }, "command-console-exec");
        }
        catch (Exception e) {
            FocessQQ.getLogger().thrLang("exception-exec-console-command", e, new Object[0]);
        }
    }
}

