/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.event.request;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.bot.contact.Group;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.event.bot.BotEvent;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;

@PermissionEnv(values={Permission.FRIEND_REQUEST_ACCEPT, Permission.FRIEND_REQUEST_REFUSE})
public class FriendRequestEvent
extends BotEvent {
    private static final ListenerHandler LISTENER_HANDLER = new ListenerHandler();
    private final long id;
    private final String nick;
    private final Group group;
    private final String message;
    private Boolean accept;
    private boolean blacklist;

    public FriendRequestEvent(Bot bot, long id, String nick, @Nullable Group group, String message) {
        super(bot);
        this.id = id;
        this.nick = nick;
        this.group = group;
        this.message = message;
    }

    public long getId() {
        return this.id;
    }

    public @NonNull String getNick() {
        return this.nick;
    }

    public @Nullable Group getGroup() {
        return this.group;
    }

    public @NonNull String getMessage() {
        return this.message;
    }

    public void accept() {
        Permission.checkPermission(Permission.FRIEND_REQUEST_ACCEPT);
        this.accept = true;
    }

    public @Nullable Boolean getAccept() {
        return this.accept;
    }

    public void refuse() {
        Permission.checkPermission(Permission.FRIEND_REQUEST_REFUSE);
        this.refuse(false);
    }

    public void refuse(boolean blacklist) {
        this.accept = false;
        this.blacklist = blacklist;
    }

    public boolean isBlackList() {
        return this.blacklist;
    }
}

