/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.plugin;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.command.DataCollection;
import top.focess.command.DataConverter;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandLine;
import top.focess.qq.api.command.DataCollection;
import top.focess.qq.api.command.SpecialArgumentComplexHandler;
import top.focess.qq.api.event.Listener;
import top.focess.qq.api.event.ListenerHandler;
import top.focess.qq.api.plugin.PluginDescription;
import top.focess.qq.api.plugin.PluginDuplicateException;
import top.focess.qq.api.plugin.PluginLoaderException;
import top.focess.qq.api.plugin.PluginUnloadException;
import top.focess.qq.api.util.config.DefaultConfig;
import top.focess.qq.api.util.config.LangConfig;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;
import top.focess.qq.core.plugin.PluginClassLoader;
import top.focess.qq.core.plugin.PluginCoreClassLoader;
import top.focess.qq.core.util.MethodCaller;
import top.focess.util.serialize.FocessSerializable;
import top.focess.util.version.Version;
import top.focess.util.yaml.YamlLoadException;

@PermissionEnv(values={Permission.INIT_PLUGIN})
public abstract class Plugin
implements FocessSerializable {
    private String author;
    private Version version;
    private String name;
    private LangConfig langConfig;
    private DefaultConfig defaultConfig;
    private PluginDescription pluginDescription;
    private boolean isEnabled;
    private boolean initialized;

    public Plugin() {
        if (this.getClass() == FocessQQ.MainPlugin.class) {
            this.initialize(new PluginDescription());
        }
    }

    @NotNull
    public static @UnmodifiableView List<Plugin> getPlugins() {
        return PluginClassLoader.getPlugins();
    }

    public static @Nullable Plugin getPlugin(Class<? extends Plugin> plugin) {
        return PluginClassLoader.getPlugin(plugin);
    }

    public static @Nullable Plugin getPlugin(String name) {
        return PluginClassLoader.getPlugin(name);
    }

    public static @Nullable Plugin thisPlugin() {
        return PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
    }

    public static @NonNull Plugin plugin() {
        Plugin plugin = PluginCoreClassLoader.getClassLoadedBy(MethodCaller.getCallerClass());
        return plugin == null ? FocessQQ.getMainPlugin() : plugin;
    }

    public final @NonNull String getName() {
        return this.name;
    }

    public abstract void enable();

    public abstract void disable();

    public final void onEnable() {
        this.isEnabled = true;
        this.enable();
    }

    public final void onDisable() {
        this.disable();
        this.isEnabled = false;
    }

    public final @NonNull File getDefaultFolder() {
        return new File("plugins", this.getName());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public final void registerListener(Listener listener) {
        ListenerHandler.register(this, listener);
    }

    public final void registerCommand(Command command) {
        Command.register(this, command);
    }

    public final void registerBuffer(DataConverter<?> dataConverter, DataCollection.BufferGetter bufferGetter) {
        DataCollection.register(this, dataConverter, bufferGetter);
    }

    public final String getAuthor() {
        return this.author;
    }

    public final Version getVersion() {
        return this.version;
    }

    public final LangConfig getLangConfig() {
        return this.langConfig;
    }

    public final DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public final PluginDescription getPluginDescription() {
        return this.pluginDescription;
    }

    public final @Nullable InputStream loadResource(String path) {
        return this.getClass().getClassLoader().getResourceAsStream(path);
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void unload() {
        throw new PluginUnloadException();
    }

    public final void registerSpecialArgumentComplexHandler(String name, SpecialArgumentComplexHandler handler) {
        CommandLine.register(this, name, handler);
    }

    public @Nullable Map<String, Object> serialize() {
        HashMap map = Maps.newHashMap();
        map.put("name", this.name);
        return map;
    }

    public static @Nullable Plugin deserialize(Map<String, Object> map) {
        return Plugin.getPlugin((String)map.get("name"));
    }

    public @Nullable File getFile() {
        if (this.getClass().getClassLoader() instanceof PluginClassLoader) {
            return ((PluginClassLoader)this.getClass().getClassLoader()).getFile();
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(@NonNull PluginDescription pluginDescription) {
        File config;
        Permission.checkPermission(Permission.INIT_PLUGIN);
        this.pluginDescription = pluginDescription;
        if (this.getClass() != FocessQQ.MainPlugin.class || FocessQQ.isRunning()) {
            this.name = this.pluginDescription.getName();
            this.author = this.pluginDescription.getAuthor();
            this.version = this.pluginDescription.getVersion();
            if (Plugin.getPlugin(this.getClass()) != null) {
                throw new PluginDuplicateException(this.name, "Cannot new a plugin at runtime");
            }
        } else {
            this.name = this.pluginDescription.getName();
            this.author = this.pluginDescription.getAuthor();
            this.version = this.pluginDescription.getVersion();
        }
        if (this.name.isEmpty()) {
            throw new IllegalArgumentException("Plugin name cannot be empty");
        }
        if (!(this.getClass().getClassLoader() instanceof PluginClassLoader) && this.getClass() != FocessQQ.MainPlugin.class) {
            throw new PluginLoaderException(this.name);
        }
        if (FocessQQ.getVersion().lower(this.pluginDescription.getRequireVersion()) || !this.pluginDescription.getLimitVersion().equals((Object)FocessQQ.getVersion())) {
            throw new IllegalStateException("Version limitation not satisfied");
        }
        if (!this.getClass().getName().equals(this.pluginDescription.getMain())) {
            throw new IllegalStateException("Cannot new a plugin at runtime");
        }
        if (!this.getDefaultFolder().exists() && !this.getDefaultFolder().mkdirs()) {
            FocessQQ.getLogger().debugLang("create-default-folder-failed", this.getDefaultFolder().getAbsolutePath());
        }
        if (!(config = new File(this.getDefaultFolder(), "config.yml")).exists()) {
            try {
                InputStream configResource = this.loadResource("config.yml");
                if (configResource != null) {
                    Files.copy(configResource, config.toPath(), new CopyOption[0]);
                    configResource.close();
                } else if (!config.createNewFile()) {
                    FocessQQ.getLogger().debugLang("create-config-file-failed", config.getAbsolutePath());
                }
            }
            catch (IOException e) {
                FocessQQ.getLogger().thrLang("exception-create-config-file", e, new Object[0]);
            }
        }
        try {
            this.defaultConfig = new DefaultConfig(config);
        }
        catch (YamlLoadException e) {
            FocessQQ.getLogger().thrLang("exception-load-default-configuration", e, new Object[0]);
        }
        this.langConfig = new LangConfig(this.loadResource("lang.yml"));
        this.initialized = true;
    }
}

