/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot.contact;

import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import top.focess.qq.api.bot.Bot;
import top.focess.qq.api.bot.contact.Transmitter;
import top.focess.qq.api.bot.message.Image;
import top.focess.qq.api.bot.message.Message;
import top.focess.qq.core.bot.contact.SimpleContact;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;

@PermissionEnv(values={Permission.UPLOAD_IMAGE, Permission.SEND_MESSAGE})
public abstract class SimpleTransmitter
extends SimpleContact
implements Transmitter {
    public SimpleTransmitter(Bot bot, long id) {
        super(bot, id);
    }

    @Override
    public void sendMessage(String message) {
        Permission.checkPermission(Permission.SEND_MESSAGE);
        this.getBot().sendMessage((Transmitter)this, message);
    }

    @Override
    public void sendMessage(@NotNull Message message) {
        Permission.checkPermission(Permission.SEND_MESSAGE);
        this.getBot().sendMessage((Transmitter)this, message);
    }

    @Override
    public Image uploadImage(InputStream inputStream) {
        Permission.checkPermission(Permission.UPLOAD_IMAGE);
        return this.getBot().uploadImage(this, inputStream);
    }
}

