/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.focess.command.CommandArgument;
import top.focess.command.CommandResult;
import top.focess.command.DataConverter;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.converter.PermissionDataConverter;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;

public class PluginCommand
extends Command {
    public PluginCommand() {
        super("plugin", new String[0]);
    }

    @Override
    public void init() {
        this.setExecutorPermission(i -> i.isAdministrator() || i.isConsole());
        this.addExecutor((sender, data, ioHandler) -> {
            if (FocessQQ.getPlugins().size() != 0) {
                StringBuilder stringBuilder = new StringBuilder(FocessQQ.getLangConfig().get("plugin-command-list"));
                for (Plugin plugin : FocessQQ.getPlugins()) {
                    stringBuilder.append(' ').append(plugin.getName());
                }
                stringBuilder.append('(').append(FocessQQ.getPlugins().size()).append(')');
                ioHandler.output(stringBuilder.toString());
            } else {
                ioHandler.outputLang("plugin-command-no-plugin", new Object[0]);
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"list"));
        this.addExecutor((sender, data, ioHandler) -> {
            Permission permission = (Permission)((Object)((Object)data.get(Permission.class)));
            StringBuilder stringBuilder = new StringBuilder();
            for (Plugin plugin : FocessQQ.getPlugins()) {
                if (!plugin.getPluginDescription().hasPermission(permission)) continue;
                stringBuilder.append(' ').append(plugin.getName());
            }
            if (stringBuilder.length() != 0) {
                stringBuilder.insert(0, String.format(FocessQQ.getLangConfig().get("plugin-command-list-permission"), permission.getName()));
                ioHandler.output(stringBuilder.toString());
            } else {
                ioHandler.outputLang("plugin-command-no-permission-matched", permission.getName());
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"permission"), CommandArgument.of((DataConverter)PermissionDataConverter.PERMISSION_DATA_CONVERTER));
    }

    @Override
    @NotNull
    public List<String> usage(CommandSender sender) {
        return Lists.newArrayList((Object[])new String[]{"Use: plugin list"});
    }
}

