/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.bot;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.qq.api.bot.BotLoginException;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.bot.BotProtocol;
import top.focess.qq.api.bot.contact.Friend;
import top.focess.qq.api.bot.contact.Group;
import top.focess.qq.api.bot.contact.Member;
import top.focess.qq.api.bot.contact.OtherClient;
import top.focess.qq.api.bot.contact.Speaker;
import top.focess.qq.api.bot.contact.Stranger;
import top.focess.qq.api.bot.contact.Transmitter;
import top.focess.qq.api.bot.message.Audio;
import top.focess.qq.api.bot.message.Image;
import top.focess.qq.api.bot.message.Message;
import top.focess.qq.api.bot.message.TextMessage;
import top.focess.qq.api.plugin.Plugin;

public interface Bot {
    public boolean relogin() throws BotLoginException;

    public boolean login() throws BotLoginException;

    public boolean logout();

    default public @NonNull Friend getFriendOrFail(long id) {
        return Objects.requireNonNull(this.getFriend(id));
    }

    default public @NonNull Group getGroupOrFail(long id) {
        return Objects.requireNonNull(this.getGroup(id));
    }

    public @Nullable Group getGroup(long var1);

    public @Nullable Friend getFriend(long var1);

    public @NonNull @UnmodifiableView List<Friend> getFriends();

    public @NonNull @UnmodifiableView List<Group> getGroups();

    public boolean isOnline();

    public @NonNull Friend getAsFriend();

    public long getId();

    public boolean isDefaultBot();

    public Plugin getPlugin();

    public boolean isAdministrator();

    default public boolean isOffline() {
        return !this.isOnline();
    }

    public BotManager getBotManager();

    public void sendMessage(Transmitter var1, Message var2);

    default public void sendMessage(Transmitter transmitter, String message) {
        this.sendMessage(transmitter, new TextMessage(message));
    }

    public Image uploadImage(Transmitter var1, InputStream var2);

    public @Nullable Audio uploadAudio(Speaker var1, InputStream var2);

    public void deleteFriend(Friend var1);

    public void quitGroup(Group var1);

    public @Nullable Member getMember(Group var1, long var2);

    default public Member getMemberOrFail(Group group, long id) {
        return Objects.requireNonNull(this.getMember(group, id));
    }

    public Member getAsMember(Group var1);

    public List<Member> getMembers(Group var1);

    public @Nullable Stranger getStranger(long var1);

    default public Stranger getStrangerOrFail(long id) {
        return Objects.requireNonNull(this.getStranger(id));
    }

    default public OtherClient getOtherClientOrFail(long id) {
        return Objects.requireNonNull(this.getOtherClient(id));
    }

    public @Nullable OtherClient getOtherClient(long var1);

    public BotProtocol getBotProtocol();
}

