/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.bot.mirai;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.imageio.stream.FileImageOutputStream;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import net.mamoe.mirai.Bot;
import net.mamoe.mirai.BotFactory;
import net.mamoe.mirai.auth.BotAuthorization;
import net.mamoe.mirai.auth.QRCodeLoginListener;
import net.mamoe.mirai.contact.Friend;
import net.mamoe.mirai.contact.Group;
import net.mamoe.mirai.contact.OtherClient;
import net.mamoe.mirai.event.Listener;
import net.mamoe.mirai.event.events.BotInvitedJoinGroupRequestEvent;
import net.mamoe.mirai.event.events.FriendInputStatusChangedEvent;
import net.mamoe.mirai.event.events.FriendMessageEvent;
import net.mamoe.mirai.event.events.GroupMessageEvent;
import net.mamoe.mirai.event.events.MemberCardChangeEvent;
import net.mamoe.mirai.event.events.MemberPermissionChangeEvent;
import net.mamoe.mirai.event.events.MessagePostSendEvent;
import net.mamoe.mirai.event.events.MessagePreSendEvent;
import net.mamoe.mirai.event.events.MessageRecallEvent;
import net.mamoe.mirai.event.events.MessageSyncEvent;
import net.mamoe.mirai.event.events.NewFriendRequestEvent;
import net.mamoe.mirai.event.events.StrangerMessageEvent;
import net.mamoe.mirai.message.data.MessageSource;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.DeviceVerificationRequests;
import net.mamoe.mirai.utils.DeviceVerificationResult;
import net.mamoe.mirai.utils.LoginSolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import top.focess.command.InputTimeoutException;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.bot.BotLoginException;
import top.focess.qq.api.bot.BotManager;
import top.focess.qq.api.bot.BotProtocol;
import top.focess.qq.api.bot.contact.Contact;
import top.focess.qq.api.bot.contact.Member;
import top.focess.qq.api.bot.contact.Stranger;
import top.focess.qq.api.event.EventManager;
import top.focess.qq.api.event.EventSubmitException;
import top.focess.qq.api.event.bot.BotLoginEvent;
import top.focess.qq.api.event.bot.BotLogoutEvent;
import top.focess.qq.api.event.bot.BotPreSendMessageEvent;
import top.focess.qq.api.event.bot.BotReloginEvent;
import top.focess.qq.api.event.bot.BotSendMessageEvent;
import top.focess.qq.api.event.bot.FriendInputStatusEvent;
import top.focess.qq.api.event.chat.FriendChatEvent;
import top.focess.qq.api.event.chat.GroupChatEvent;
import top.focess.qq.api.event.chat.StrangerChatEvent;
import top.focess.qq.api.event.group.MemberCardNameChangeEvent;
import top.focess.qq.api.event.group.MemberCommandPermissionChangeEvent;
import top.focess.qq.api.event.recall.FriendRecallEvent;
import top.focess.qq.api.event.recall.GroupRecallEvent;
import top.focess.qq.api.event.request.FriendRequestEvent;
import top.focess.qq.api.event.request.GroupRequestEvent;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.api.scheduler.Schedulers;
import top.focess.qq.api.util.IOHandler;
import top.focess.qq.core.bot.contact.SimpleMember;
import top.focess.qq.core.bot.mirai.MiraiBot;
import top.focess.qq.core.bot.mirai.message.MiraiMessage;
import top.focess.qq.core.bot.mirai.message.MiraiMessageChain;
import top.focess.qq.core.bot.mirai.message.MiraiMessageSource;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;
import top.focess.scheduler.Scheduler;

@PermissionEnv(values={Permission.REMOVE_BOT_MANAGER, Permission.BOT_LOGIN, Permission.BOT_LOGOUT, Permission.BOT_RELOGIN})
public class MiraiBotManager
implements BotManager {
    private static final Scheduler SCHEDULER = Schedulers.newFocessScheduler(FocessQQ.getMainPlugin(), "BotManager");
    private static final Map<top.focess.qq.api.bot.Bot, List<Listener<?>>> BOT_LISTENER_MAP = Maps.newHashMap();
    private static final Map<Plugin, List<top.focess.qq.api.bot.Bot>> PLUGIN_BOT_MAP = Maps.newHashMap();
    private static final Map<Long, top.focess.qq.api.bot.Bot> BOTS = Maps.newConcurrentMap();

    @Override
    public void removeAll() {
        top.focess.qq.api.bot.Bot b;
        Permission.checkPermission(Permission.REMOVE_BOT_MANAGER);
        for (Long id : BOTS.keySet()) {
            this.remove(id);
        }
        if (FocessQQ.getBot() != null && (b = BOTS.remove(FocessQQ.getBot().getId())) != null) {
            b.logout();
        }
        PLUGIN_BOT_MAP.clear();
    }

    @Override
    public void remove(Plugin plugin) {
        Permission.checkPermission(Permission.REMOVE_BOT_MANAGER);
        for (top.focess.qq.api.bot.Bot b : PLUGIN_BOT_MAP.getOrDefault(plugin, Lists.newArrayList())) {
            this.remove(b.getId());
        }
        PLUGIN_BOT_MAP.remove(plugin);
    }

    @Override
    @NotNull
    public Future<top.focess.qq.api.bot.Bot> login(long id, String password, Plugin plugin, BotProtocol protocol) {
        Permission.checkPermission(Permission.BOT_LOGIN);
        return SCHEDULER.submit(() -> this.loginDirectly(id, password, plugin, protocol), "login-bot-" + id);
    }

    @Override
    @NotNull
    public top.focess.qq.api.bot.Bot loginDirectly(long id, String password, Plugin plugin, BotProtocol botProtocol) throws BotLoginException {
        Permission.checkPermission(Permission.BOT_LOGIN);
        Bot bot = this.login0(id, password, botProtocol);
        MiraiBot b = new MiraiBot(id, password, bot, botProtocol, plugin, this);
        this.setup(b, bot);
        PLUGIN_BOT_MAP.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newArrayList();
            }
            v.add(b);
            return v;
        });
        BOTS.put(id, b);
        return b;
    }

    @Override
    public boolean login(top.focess.qq.api.bot.Bot b) throws BotLoginException {
        Permission.checkPermission(Permission.BOT_LOGIN);
        this.checkBot(b);
        if (b.isOnline()) {
            return false;
        }
        long id = b.getId();
        String password = ((MiraiBot)b).getPassword();
        BotProtocol botProtocol = b.getBotProtocol();
        this.setup((MiraiBot)b, this.login0(id, password, botProtocol));
        return true;
    }

    private Bot login0(final long id, String password, BotProtocol botProtocol) throws BotLoginException {
        BotConfiguration configuration = BotConfiguration.getDefault();
        configuration.setProtocol(MiraiBotManager.getProtocol(botProtocol));
        File cache = new File("devices/" + id + "/cache");
        if (!cache.exists() && !cache.mkdirs()) {
            throw new BotLoginException(id, FocessQQ.getLangConfig().get("fatal-create-cache-dir-failed"));
        }
        configuration.fileBasedDeviceInfo("devices/" + id + "/device.json");
        configuration.setCacheDir(cache);
        configuration.setLoginSolver(new LoginSolver(){

            @Nullable
            public Object onSolvePicCaptcha(@NotNull Bot bot, byte @NotNull [] bytes, @NotNull Continuation<? super String> continuation) {
                try {
                    FileImageOutputStream outputStream = new FileImageOutputStream(new File("captcha.jpg"));
                    outputStream.write(bytes);
                    outputStream.close();
                }
                catch (IOException e) {
                    FocessQQ.getLogger().thrLang("exception-load-captcha-picture", e, new Object[0]);
                }
                FocessQQ.getLogger().infoLang("input-captcha-code", new Object[0]);
                try {
                    return IOHandler.getConsoleIoHandler().inputMessage().toString();
                }
                catch (InputTimeoutException e) {
                    return null;
                }
            }

            @Nullable
            public Object onSolveSliderCaptcha(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                FocessQQ.getLogger().info(s);
                try {
                    return IOHandler.getConsoleIoHandler().inputMessage().toString();
                }
                catch (InputTimeoutException ignored) {
                    return null;
                }
            }

            @Nullable
            public Object onSolveUnsafeDeviceLoginVerify(@NotNull Bot bot, @NotNull String s, @NotNull Continuation<? super String> continuation) {
                FocessQQ.getLogger().info(s);
                try {
                    return IOHandler.getConsoleIoHandler().inputMessage().toString();
                }
                catch (InputTimeoutException ignored) {
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public Object onSolveDeviceVerification(@NotNull Bot bot, @NotNull DeviceVerificationRequests requests, @NotNull Continuation<? super DeviceVerificationResult> continuation) {
                if (requests.getPreferSms()) {
                    String code;
                    FocessQQ.getLogger().info(requests.getSms().getCountryCode() + " " + requests.getSms().getPhoneNumber());
                    try {
                        IOHandler.getConsoleIoHandler().inputMessage();
                    }
                    catch (InputTimeoutException inputTimeoutException) {
                        // empty catch block
                    }
                    final Object lock = new Object();
                    requests.getSms().requestSms((Continuation)new Continuation<Unit>(){

                        @NotNull
                        public CoroutineContext getContext() {
                            return EmptyCoroutineContext.INSTANCE;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void resumeWith(@NotNull Object result) {
                            Object object = lock;
                            synchronized (object) {
                                lock.notify();
                            }
                        }
                    });
                    Object object = lock;
                    synchronized (object) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        code = IOHandler.getConsoleIoHandler().inputMessage().toString();
                    }
                    catch (InputTimeoutException ignored) {
                        code = "";
                    }
                    return requests.getSms().solved(code);
                }
                FocessQQ.getLogger().info(requests.getFallback().getUrl());
                try {
                    IOHandler.getConsoleIoHandler().inputMessage();
                }
                catch (InputTimeoutException inputTimeoutException) {
                    // empty catch block
                }
                return requests.getFallback().solved();
            }

            @NotNull
            public QRCodeLoginListener createQRCodeLoginListener(@NotNull Bot bot) {
                return new QRCodeLoginListener(){

                    public void onStateChanged(@NotNull Bot bot, @NotNull QRCodeLoginListener.State state) {
                        FocessQQ.getLogger().infoLang("bot-login-qrcode-state", id, state.name());
                    }

                    public void onFetchQRCode(@NotNull Bot bot, @NotNull byte[] bytes) {
                        try {
                            FileImageOutputStream outputStream = new FileImageOutputStream(new File("qrcode.jpg"));
                            outputStream.write(bytes);
                            outputStream.close();
                        }
                        catch (IOException e) {
                            FocessQQ.getLogger().thrLang("exception-load-qrcode-picture", e, new Object[0]);
                        }
                    }
                };
            }
        });
        Bot bot = BotFactory.INSTANCE.newBot(id, password.equalsIgnoreCase("qr") ? BotAuthorization.byQRCode() : BotAuthorization.byPassword((String)password), configuration);
        try {
            bot.login();
        }
        catch (Exception e) {
            bot.close();
            throw new BotLoginException(id, e);
        }
        return bot;
    }

    private void setup(MiraiBot b, Bot bot) {
        b.setNativeBot(bot);
        try {
            EventManager.submit(new BotLoginEvent(b));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-login-event", e, new Object[0]);
        }
        ArrayList listeners = Lists.newArrayList();
        listeners.add(bot.getEventChannel().subscribeAlways(GroupMessageEvent.class, event -> {
            top.focess.qq.api.bot.contact.Group group = Objects.requireNonNull(b.getGroup(event.getGroup()));
            GroupChatEvent e = new GroupChatEvent(b, Objects.requireNonNull(b.getMember(event.getSender())), new MiraiMessageChain(event.getMessage()), MiraiMessageSource.of((MessageSource)event.getSource()));
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException eventSubmitException) {
                FocessQQ.getLogger().thrLang("exception-submit-group-chat-event", eventSubmitException, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(FriendMessageEvent.class, event -> {
            top.focess.qq.api.bot.contact.Friend friend = Objects.requireNonNull(b.getFriend(event.getSender()));
            FriendChatEvent e = new FriendChatEvent(b, friend, new MiraiMessageChain(event.getMessage()), MiraiMessageSource.of((MessageSource)event.getSource()));
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException eventSubmitException) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-chat-event", eventSubmitException, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.GroupRecall.class, event -> {
            top.focess.qq.api.bot.contact.Group group = Objects.requireNonNull(b.getGroup(event.getGroup()));
            GroupRecallEvent e = new GroupRecallEvent(b, Objects.requireNonNull(b.getMember((net.mamoe.mirai.contact.Member)event.getAuthor())), event.getMessageIds(), b.getMember(event.getOperator()));
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-group-recall-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessageRecallEvent.FriendRecall.class, event -> {
            top.focess.qq.api.bot.contact.Friend friend = Objects.requireNonNull(b.getFriend(event.getAuthor()));
            FriendRecallEvent e = new FriendRecallEvent(b, friend, event.getMessageIds());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-recall-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(NewFriendRequestEvent.class, event -> {
            top.focess.qq.api.bot.contact.Group group = b.getGroup(event.getFromGroup());
            FriendRequestEvent e = new FriendRequestEvent(b, event.getFromId(), event.getFromNick(), group, event.getMessage());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-request-event", ex, new Object[0]);
            }
            if (e.getAccept() != null) {
                if (e.getAccept().booleanValue()) {
                    event.accept();
                } else {
                    event.reject(e.isBlackList());
                }
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(BotInvitedJoinGroupRequestEvent.class, event -> {
            top.focess.qq.api.bot.contact.Friend friend = b.getFriend(event.getInvitor());
            GroupRequestEvent e = new GroupRequestEvent(b, event.getGroupId(), event.getGroupName(), friend);
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-group-request-event", ex, new Object[0]);
            }
            if (e.getAccept() != null) {
                if (e.getAccept().booleanValue()) {
                    event.accept();
                } else {
                    event.ignore();
                }
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(FriendInputStatusChangedEvent.class, event -> {
            top.focess.qq.api.bot.contact.Friend friend = Objects.requireNonNull(b.getFriend(event.getFriend()));
            FriendInputStatusEvent e = new FriendInputStatusEvent(b, friend, event.getInputting());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-friend-input-status-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(StrangerMessageEvent.class, event -> {
            Stranger stranger = Objects.requireNonNull(b.getStranger(event.getStranger()));
            StrangerChatEvent e = new StrangerChatEvent(b, stranger, new MiraiMessageChain(event.getMessage()), MiraiMessageSource.of((MessageSource)event.getSource()));
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-stranger-chat-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessagePostSendEvent.class, event -> {
            Contact contact = MiraiBotManager.getContact(b, event.getTarget());
            BotSendMessageEvent e = new BotSendMessageEvent(b, new MiraiMessageChain(event.getMessage()), contact);
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-bot-send-message-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessagePreSendEvent.class, event -> {
            Contact contact = MiraiBotManager.getContact(b, event.getTarget());
            BotPreSendMessageEvent e = new BotPreSendMessageEvent(b, new MiraiMessage(event.getMessage()), contact);
            try {
                EventManager.submit(e);
                if (e.isNeedUpdate() && e.getMessage() instanceof MiraiMessage) {
                    event.setMessage(((MiraiMessage)e.getMessage()).getMessage());
                }
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-bot-pre-send-message-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MessageSyncEvent.class, event -> {
            Contact contact = MiraiBotManager.getContact(b, event.getSubject());
            BotSendMessageEvent e = new BotSendMessageEvent(b, new MiraiMessageChain(event.getMessage()), contact);
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-bot-send-message-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MemberPermissionChangeEvent.class, event -> {
            top.focess.qq.api.bot.contact.Group group = Objects.requireNonNull(b.getGroup(event.getGroup()));
            Member member = Objects.requireNonNull(group.getMember(event.getMember().getId()));
            ((SimpleMember)member).setPermission(MiraiBot.toCommandPermission(event.getNew()));
            MemberCommandPermissionChangeEvent e = new MemberCommandPermissionChangeEvent(member, MiraiBot.toCommandPermission(event.getOrigin()), MiraiBot.toCommandPermission(event.getNew()));
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-member-permission-change-event", ex, new Object[0]);
            }
        }));
        listeners.add(bot.getEventChannel().subscribeAlways(MemberCardChangeEvent.class, event -> {
            top.focess.qq.api.bot.contact.Group group = Objects.requireNonNull(b.getGroup(event.getGroup()));
            Member member = Objects.requireNonNull(group.getMember(event.getMember().getId()));
            ((SimpleMember)member).setCardName(event.getNew());
            MemberCardNameChangeEvent e = new MemberCardNameChangeEvent(member, event.getOrigin(), event.getNew());
            try {
                EventManager.submit(e);
            }
            catch (EventSubmitException ex) {
                FocessQQ.getLogger().thrLang("exception-submit-member-card-change-event", ex, new Object[0]);
            }
        }));
        BOT_LISTENER_MAP.put(b, listeners);
    }

    @Override
    public boolean logout(@NotNull top.focess.qq.api.bot.Bot bot) {
        Permission.checkPermission(Permission.BOT_LOGOUT);
        this.checkBot(bot);
        if (!bot.isOnline()) {
            return false;
        }
        ((MiraiBot)bot).getNativeBot().close();
        for (Listener listener : (List)BOT_LISTENER_MAP.getOrDefault(bot, Lists.newArrayList())) {
            listener.complete();
        }
        BOT_LISTENER_MAP.remove(bot);
        try {
            EventManager.submit(new BotLogoutEvent(bot));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-logout-event", e, new Object[0]);
        }
        return true;
    }

    @Override
    @Nullable
    public top.focess.qq.api.bot.Bot getBot(long username) {
        return BOTS.get(username);
    }

    @Override
    public boolean relogin(@NotNull top.focess.qq.api.bot.Bot bot) throws BotLoginException {
        Permission.checkPermission(Permission.BOT_RELOGIN);
        this.checkBot(bot);
        boolean ret = this.logout(bot) && this.login(bot);
        try {
            EventManager.submit(new BotReloginEvent(bot));
        }
        catch (EventSubmitException e) {
            FocessQQ.getLogger().thrLang("exception-submit-bot-relogin-event", e, new Object[0]);
        }
        return ret;
    }

    @Override
    public @UnmodifiableView List<top.focess.qq.api.bot.Bot> getBots() {
        return Collections.unmodifiableList(Lists.newArrayList(BOTS.values()));
    }

    @Override
    @Nullable
    public top.focess.qq.api.bot.Bot remove(long id) {
        Permission.checkPermission(Permission.REMOVE_BOT_MANAGER);
        if (FocessQQ.getBot().getId() == id) {
            return null;
        }
        top.focess.qq.api.bot.Bot b = BOTS.remove(id);
        if (b != null) {
            b.logout();
        }
        return b;
    }

    private void checkBot(@NotNull top.focess.qq.api.bot.Bot bot) {
        if (!(bot instanceof MiraiBot)) {
            throw new IllegalArgumentException("Bot must be instanced of MiraiBot");
        }
    }

    private static BotConfiguration.MiraiProtocol getProtocol(BotProtocol botProtocol) {
        switch (botProtocol) {
            case IPAD: {
                return BotConfiguration.MiraiProtocol.IPAD;
            }
            case MACOS: {
                return BotConfiguration.MiraiProtocol.MACOS;
            }
            case ANDROID_PAD: {
                return BotConfiguration.MiraiProtocol.ANDROID_PAD;
            }
            case ANDROID_PHONE: {
                return BotConfiguration.MiraiProtocol.ANDROID_PHONE;
            }
            case ANDROID_WATCH: {
                return BotConfiguration.MiraiProtocol.ANDROID_WATCH;
            }
        }
        throw new IllegalArgumentException("Unknown bot protocol: " + botProtocol);
    }

    @NotNull
    private static Contact getContact(top.focess.qq.api.bot.Bot bot, net.mamoe.mirai.contact.Contact contact) {
        if (contact instanceof Group) {
            return bot.getGroupOrFail(contact.getId());
        }
        if (contact instanceof Friend) {
            return bot.getFriendOrFail(contact.getId());
        }
        if (contact instanceof net.mamoe.mirai.contact.Member) {
            return bot.getGroupOrFail(((net.mamoe.mirai.contact.Member)contact).getGroup().getId()).getMemberOrFail(contact.getId());
        }
        if (contact instanceof Stranger) {
            return bot.getStrangerOrFail(contact.getId());
        }
        if (contact instanceof OtherClient) {
            return bot.getOtherClientOrFail(contact.getId());
        }
        throw new NullPointerException();
    }
}

