/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.focess.command.CommandArgument;
import top.focess.command.CommandResult;
import top.focess.command.DataConverter;
import top.focess.qq.api.command.Command;
import top.focess.qq.api.command.CommandSender;
import top.focess.qq.api.command.converter.PermissionDataConverter;
import top.focess.qq.api.command.converter.PluginDataConverter;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;

public class PermissionCommand
extends Command {
    public PermissionCommand() {
        super("permission", new String[0]);
    }

    @Override
    public void init() {
        this.setExecutorPermission(i -> i.isAdministrator() || i.isConsole());
        this.addExecutor((sender, data, ioHandler) -> {
            Plugin plugin = (Plugin)data.get(Plugin.class);
            if (plugin.getPluginDescription().getPermissions().isEmpty()) {
                ioHandler.outputLang("permission-command-no-permission", plugin.getName());
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                for (Permission permission : plugin.getPluginDescription().getPermissions().keySet()) {
                    stringBuilder.append(' ').append((Object)permission);
                }
                ioHandler.outputLang("permission-command-list", plugin.getName(), stringBuilder.toString());
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"get"), CommandArgument.of((DataConverter)PluginDataConverter.PLUGIN_DATA_CONVERTER));
        this.addExecutor((sender, data, ioHandler) -> {
            Plugin plugin = (Plugin)data.get(Plugin.class);
            Permission permission = (Permission)((Object)((Object)data.get(Permission.class)));
            if (plugin.getPluginDescription().addPermission(permission)) {
                ioHandler.outputLang("permission-command-set-success", plugin.getName(), permission.getName());
            } else {
                ioHandler.outputLang("permission-command-set-failed", plugin.getName(), permission.getName());
            }
            return CommandResult.ALLOW;
        }, CommandArgument.of((String)"set"), CommandArgument.of((DataConverter)PluginDataConverter.PLUGIN_DATA_CONVERTER), CommandArgument.of((DataConverter)PermissionDataConverter.PERMISSION_DATA_CONVERTER));
    }

    @Override
    @NotNull
    public List<String> usage(CommandSender sender) {
        return Lists.newArrayList((Object[])new String[]{"Use: permission set <plugin> <permission>", "Use: permission get <plugin>"});
    }
}

