/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.core.plugin;

import com.google.common.collect.Lists;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import top.focess.qq.FocessQQ;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.plugin.PluginClassLoader;

public class PluginCoreClassLoader
extends ClassLoader {
    static final PluginCoreClassLoader DEFAULT_CLASS_LOADER = new PluginCoreClassLoader(PluginCoreClassLoader.class.getClassLoader());
    static final List<PluginClassLoader> LOADERS = Lists.newCopyOnWriteArrayList();

    public PluginCoreClassLoader(ClassLoader parent) {
        super(parent);
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        return DEFAULT_CLASS_LOADER.loadClass(name, false);
    }

    public static @Nullable Plugin getPluginByClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.getClassLoader() instanceof PluginClassLoader) {
            for (PluginClassLoader pluginClassLoader : LOADERS) {
                if (!pluginClassLoader.getLoadedClasses().contains(clazz)) continue;
                return pluginClassLoader.getPlugin();
            }
        }
        return null;
    }

    public static @NonNull Plugin getPluginByClassOrDefault(@Nullable Class<?> clazz) {
        Plugin plugin = PluginCoreClassLoader.getPluginByClass(clazz);
        if (plugin == null) {
            return FocessQQ.getMainPlugin();
        }
        return plugin;
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            for (PluginClassLoader classLoader : LOADERS) {
                try {
                    return classLoader.findClass(name, resolve);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }
    }
}

