/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import top.focess.net.PackHandler;
import top.focess.net.packet.Packet;
import top.focess.qq.api.plugin.Plugin;
import top.focess.qq.core.permission.Permission;
import top.focess.qq.core.permission.PermissionEnv;

@PermissionEnv(values={Permission.SEND_PACKET, Permission.RECEIVE_PACKET})
public class ClientReceiver {
    private final Map<Plugin, Map<Class<?>, List<PackHandler>>> handlers = Maps.newConcurrentMap();
    private final top.focess.net.receiver.ClientReceiver receiver;

    public ClientReceiver(top.focess.net.receiver.ClientReceiver receiver) {
        this.receiver = receiver;
    }

    public void close() {
        this.receiver.close();
        this.handlers.clear();
    }

    public void unregisterAll() {
        this.receiver.unregisterAll();
        this.handlers.clear();
    }

    public void unregister(Plugin plugin) {
        Map handlers = this.handlers.getOrDefault(plugin, Maps.newConcurrentMap());
        handlers.values().forEach(v -> v.forEach(arg_0 -> ((top.focess.net.receiver.ClientReceiver)this.receiver).unregister(arg_0)));
        this.handlers.remove(plugin);
    }

    public void sendPacket(Packet packet) {
        Permission.checkPermission(Permission.SEND_PACKET);
        this.receiver.sendPacket(packet);
    }

    public <T extends Packet> void register(Plugin plugin, Class<T> packet, PackHandler<T> packHandler) {
        Permission.checkPermission(Permission.RECEIVE_PACKET);
        this.handlers.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Maps.newConcurrentMap();
            }
            v.compute(packet, (k1, v1) -> {
                if (v1 == null) {
                    v1 = Lists.newArrayList();
                }
                v1.add(packHandler);
                return v1;
            });
            return v;
        });
        this.receiver.register(packet, packHandler);
    }

    public String getName() {
        return this.receiver.getName();
    }

    public String getHost() {
        return this.receiver.getHost();
    }

    public int getPort() {
        return this.receiver.getPort();
    }

    public boolean isConnected() {
        return this.receiver.isConnected();
    }

    public int getClientId() {
        return this.receiver.getClientId();
    }

    public String getClientToken() {
        return this.receiver.getClientToken();
    }
}

