/*
 * Decompiled with CFR 0.152.
 */
package top.focess.qq.api.net;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import top.focess.net.receiver.Receiver;
import top.focess.qq.api.plugin.Plugin;

public class Socket {
    private final top.focess.net.socket.Socket socket;
    private final Map<Plugin, List<Receiver>> receivers = Maps.newConcurrentMap();

    public Socket(top.focess.net.socket.Socket socket) {
        this.socket = socket;
    }

    public void registerReceiver(Plugin plugin, Receiver receiver) {
        this.receivers.compute(plugin, (k, v) -> {
            if (v == null) {
                v = Lists.newCopyOnWriteArrayList();
            }
            v.add(receiver);
            return v;
        });
        this.socket.registerReceiver(receiver);
    }

    public boolean isServerSide() {
        return this.socket.isServerSide();
    }

    public boolean isClientSide() {
        return this.socket.isClientSide();
    }

    public void close() {
        this.socket.close();
        this.receivers.clear();
    }

    public void unregister(Plugin plugin) {
        List<Receiver> receivers = this.receivers.getOrDefault(plugin, Lists.newArrayList());
        receivers.forEach(arg_0 -> ((top.focess.net.socket.Socket)this.socket).unregister(arg_0));
        this.receivers.remove(plugin);
    }

    public void unregisterAll() {
        this.socket.unregisterAll();
        this.receivers.clear();
    }
}

